const GAME_NAME = "DELTARUNE";
const GAME_VERSION = "1.0.0.0";

const CACHE_NAME = JSON.stringify({"name": GAME_NAME, "version": GAME_VERSION});
const CACHE_FILES = ["runner.data",
"runner.js",
"runner.wasm",
"audio-worklet.js",
"audio_intronoise.ogg",
"game.unx",
"snd_bigcar_yelp.ogg",
"snd_closet_fall.ogg",
"snd_closet_impact.ogg",
"snd_dtrans_drone.ogg",
"snd_dtrans_flip.ogg",
"snd_dtrans_heavypassing.ogg",
"snd_dtrans_lw.ogg",
"snd_dtrans_square.ogg",
"snd_dtrans_twinkle.ogg",
"snd_fountain_make.ogg",
"snd_fountain_target.ogg",
"snd_ghostappear.ogg",
"snd_great_shine.ogg",
"snd_him_quick.ogg",
"snd_hitcar.ogg",
"snd_hitcar_little.ogg",
"snd_icespell.ogg",
"snd_paper_rumble.ogg",
"snd_paper_surf.ogg",
"snd_revival.ogg",
"snd_rurus_appear.ogg",
"snd_smallcar_yelp.ogg",
"snd_snowgrave.ogg",
"snd_spell_pacify.ogg",
"snd_usefountain.ogg",
"mus/acid_tunnel.ogg",
"mus/afterrain_inside.ogg",
"mus/alarm_titlescreen.ogg",
"mus/alley_ambience.ogg",
"mus/alt_church_lobby.ogg",
"mus/ambientwater_weird.ogg",
"mus/annoying_prophecy.ogg",
"mus/april_2012.ogg",
"mus/audio_anotherhim.ogg",
"mus/audio_darkness.ogg",
"mus/audio_defeat.ogg",
"mus/audio_drone.ogg",
"mus/audio_story.ogg",
"mus/baci_distort.ogg",
"mus/baci_perugina.ogg",
"mus/basement.ogg",
"mus/battle.ogg",
"mus/battle_preview.ogg",
"mus/battle_preview_crisp.ogg",
"mus/battle_vapor.ogg",
"mus/bell_ambience.ogg",
"mus/berdly_audience.ogg",
"mus/berdly_battle_heartbeat_true.ogg",
"mus/berdly_chase.ogg",
"mus/berdly_descend.ogg",
"mus/berdly_flashback.ogg",
"mus/berdly_theme.ogg",
"mus/bird.ogg",
"mus/board4_rhythm.ogg",
"mus/board_4.ogg",
"mus/board_4_challenge.ogg",
"mus/board_lancer_dig.ogg",
"mus/board_ocean.ogg",
"mus/board_sword_music.ogg",
"mus/board_zelda.ogg",
"mus/boxing_boss.ogg",
"mus/boxing_boss_preview.ogg",
"mus/boxing_boss_preview_crisp.ogg",
"mus/boxing_game.ogg",
"mus/card_castle.ogg",
"mus/carol_appeared.ogg",
"mus/castletown.ogg",
"mus/castletown_empty.ogg",
"mus/castle_funk_long.ogg",
"mus/ch2_credits.ogg",
"mus/ch3-practice_song_combined.ogg",
"mus/ch3-practice_song_noguit.ogg",
"mus/ch3_board1.ogg",
"mus/ch3_board2.ogg",
"mus/ch3_board3.ogg",
"mus/ch3_karaoke_example_guitar_only_v2.ogg",
"mus/ch3_karaoke_example_guit_only.ogg",
"mus/ch3_karaoke_example_noguit.ogg",
"mus/ch3_karaoke_example_noguitar_v2.ogg",
"mus/ch3_karaoke_example_together_ex.ogg",
"mus/ch3_karaoke_full.ogg",
"mus/ch3_karaoke_no_guitar.ogg",
"mus/ch3_karaoke_preview.ogg",
"mus/ch3_karaoke_preview_crisp.ogg",
"mus/ch3_south_of_the_border.ogg",
"mus/ch3_tvtime.ogg",
"mus/ch3_tvtime_guitar.ogg",
"mus/ch4_battle.ogg",
"mus/ch4_credits.ogg",
"mus/ch4_extra_boss.ogg",
"mus/ch4_first_intro.ogg",
"mus/ch4_first_intro_breaking.ogg",
"mus/charjoined.ogg",
"mus/checkers.ogg",
"mus/church_dark_study.ogg",
"mus/church_hymn.ogg",
"mus/church_lightning.ogg",
"mus/church_lw.ogg",
"mus/church_lw_night.ogg",
"mus/church_wip.ogg",
"mus/church_zone2_alt_longer_test.ogg",
"mus/church_zone3.ogg",
"mus/climb.ogg",
"mus/coolbeat.ogg",
"mus/creepychase.ogg",
"mus/creepydoor.ogg",
"mus/creepylandscape.ogg",
"mus/cyber.ogg",
"mus/cybercity.ogg",
"mus/cybercity_alt.ogg",
"mus/cybercity_old.ogg",
"mus/cyberhouse.ogg",
"mus/cybershop_christmas.ogg",
"mus/cyber_battle.ogg",
"mus/cyber_battle_end.ogg",
"mus/cyber_battle_prelude.ogg",
"mus/cyber_shop.ogg",
"mus/d.ogg",
"mus/darkchurch_intro.ogg",
"mus/dark_place.ogg",
"mus/deep_noise.ogg",
"mus/dogcheck.ogg",
"mus/dontforget.ogg",
"mus/elevator.ogg",
"mus/fanfare.ogg",
"mus/field_of_hopes.ogg",
"mus/field_of_hopes_preview.ogg",
"mus/field_of_hopes_preview_crisp.ogg",
"mus/findher.ogg",
"mus/flashback_excerpt.ogg",
"mus/forest.ogg",
"mus/friendship.ogg",
"mus/gallery.ogg",
"mus/gameover_short.ogg",
"mus/gerson_defeated.ogg",
"mus/gerson_theme_intro.ogg",
"mus/gerson_theme_nointro.ogg",
"mus/giant_queen_appears.ogg",
"mus/gigaqueen_pre.ogg",
"mus/glacier.ogg",
"mus/greenroom_detune.ogg",
"mus/heartbeat.ogg",
"mus/hip_shop.ogg",
"mus/home.ogg",
"mus/honksong.ogg",
"mus/jitterbug.ogg",
"mus/jitterbug_muffled.ogg",
"mus/joker.ogg",
"mus/keygen.ogg",
"mus/kingboss.ogg",
"mus/knight.ogg",
"mus/knight_appears.ogg",
"mus/kris_piano_lancer_waltz.ogg",
"mus/kris_piano_last_prophecy.ogg",
"mus/kris_piano_lower.ogg",
"mus/kris_piano_prophecy.ogg",
"mus/kris_piano_quiz.ogg",
"mus/kris_piano_rouxls.ogg",
"mus/kris_piano_sevenfour.ogg",
"mus/kris_piano_shop.ogg",
"mus/kris_piano_waitingroom.ogg",
"mus/lancer.ogg",
"mus/lancerfight.ogg",
"mus/lancer_annoying.ogg",
"mus/lancer_susie.ogg",
"mus/legend.ogg",
"mus/legend_altered.ogg",
"mus/man.ogg",
"mus/mansion.ogg",
"mus/mansion_entrance.ogg",
"mus/man_2.ogg",
"mus/man_nes.ogg",
"mus/me.ogg",
"mus/menu.ogg",
"mus/mike.ogg",
"mus/mike_zone.ogg",
"mus/minigame_kart.ogg",
"mus/muffled_rain.ogg",
"mus/muscle.ogg",
"mus/music_guys.ogg",
"mus/music_guys_intro.ogg",
"mus/mus_birdnoise.ogg",
"mus/mus_confession.ogg",
"mus/mus_introcar.ogg",
"mus/mus_knightthought.ogg",
"mus/mus_race.ogg",
"mus/mus_school.ogg",
"mus/mus_temloopshort.ogg",
"mus/napsta_alarm.ogg",
"mus/nes_intro_extended_part2.ogg",
"mus/newscast.ogg",
"mus/nightmare_boss_heavy.ogg",
"mus/nightmare_boss_links.ogg",
"mus/nightmare_nes.ogg",
"mus/night_ambience.ogg",
"mus/noelle.ogg",
"mus/noelleshouseoutside.ogg",
"mus/noelle_distant.ogg",
"mus/noelle_ferriswheel.ogg",
"mus/noelle_house_wip.ogg",
"mus/noelle_normal.ogg",
"mus/noelle_school.ogg",
"mus/northernlight.ogg",
"mus/ocean.ogg",
"mus/oldman_helps_out.ogg",
"mus/ominous_message.ogg",
"mus/ominous_stab_harsh.ogg",
"mus/ominous_stab_harsh_2.ogg",
"mus/ominous_worse.ogg",
"mus/pianpian.ogg",
"mus/prejoker.ogg",
"mus/pumpkin_boss.ogg",
"mus/queen.ogg",
"mus/queen_boss.ogg",
"mus/queen_car_radio.ogg",
"mus/queen_intro.ogg",
"mus/quiet_autumn.ogg",
"mus/quiet_church.ogg",
"mus/rain.ogg",
"mus/raining.ogg",
"mus/raining_in_church2.ogg",
"mus/rhythm_knockdown_combined.ogg",
"mus/rhythm_knockdown_no_guit.ogg",
"mus/root_8bit.ogg",
"mus/rouxls_battle.ogg",
"mus/rtenna_zoom.ogg",
"mus/rudebuster_boss.ogg",
"mus/ruruskaado.ogg",
"mus/sadchord2.ogg",
"mus/second_church.ogg",
"mus/shinkansen.ogg",
"mus/shop1.ogg",
"mus/sinedrone_danger.ogg",
"mus/sinedrone_danger_high.ogg",
"mus/sink_noise.ogg",
"mus/smallpiano_room.ogg",
"mus/sound_battle_bg.ogg",
"mus/spamton_basement.ogg",
"mus/spamton_battle.ogg",
"mus/spamton_dance.ogg",
"mus/spamton_happy.ogg",
"mus/spamton_house.ogg",
"mus/spamton_laugh_noise.ogg",
"mus/spamton_meeting.ogg",
"mus/spamton_meeting_intro.ogg",
"mus/spamton_neo_after.ogg",
"mus/spamton_neo_meeting.ogg",
"mus/spamton_neo_mix_ex_wip.ogg",
"mus/static_placeholder.ogg",
"mus/statue2_level1.ogg",
"mus/statue2_level2.ogg",
"mus/statue2_level3.ogg",
"mus/statue2_level4.ogg",
"mus/statue2_level5.ogg",
"mus/statue_chord_basic.ogg",
"mus/statue_level1.ogg",
"mus/statue_level2.ogg",
"mus/statue_level3.ogg",
"mus/statue_level4.ogg",
"mus/stealth.ogg",
"mus/strongwind_loop.ogg",
"mus/susie_diner.ogg",
"mus/s_neo.ogg",
"mus/s_neo_clip.ogg",
"mus/tenna_battle.ogg",
"mus/tenna_battle_guitar.ogg",
"mus/tenna_battle_old.ogg",
"mus/tenna_battle_preview.ogg",
"mus/tenna_battle_preview_crisp.ogg",
"mus/tenna_island.ogg",
"mus/tense.ogg",
"mus/the_dark_truth.ogg",
"mus/the_holy.ogg",
"mus/thrashmachine.ogg",
"mus/thrash_rating.ogg",
"mus/tinnitus.ogg",
"mus/tin_night.ogg",
"mus/titan_battle.ogg",
"mus/titan_pre.ogg",
"mus/titan_spawn.ogg",
"mus/titan_tower.ogg",
"mus/town.ogg",
"mus/town_day.ogg",
"mus/trank.ogg",
"mus/tvromance.ogg",
"mus/tv_changingroom.ogg",
"mus/tv_game.ogg",
"mus/tv_hall_of_fame.ogg",
"mus/tv_infrontof.ogg",
"mus/tv_noise.ogg",
"mus/tv_results_screen.ogg",
"mus/tv_static_bad.ogg",
"mus/tv_world.ogg",
"mus/vs_susie.ogg",
"mus/w.ogg",
"mus/wet_tapdancing.ogg",
"mus/wet_tapdancing2.ogg",
"mus/wet_tapdancing_failed.ogg",
"mus/wind.ogg",
"mus/wind_highplace.ogg",
"vid/tennaintrof1_compressed_28.mp4",
"vid/tennaintrojpf1_compressed_28.mp4"
];

self.addEventListener("fetch", (event) => {
  const should_cache = CACHE_FILES.some((f) => {
      return event.request.url.endsWith(f);
  });
  event.respondWith(
    caches.match(event.request).then((resp) => {
      return resp || fetch(event.request).then((response) => {
        return caches.open(CACHE_NAME).then((cache) => {
          if (should_cache) {
            cache.put(event.request, response.clone());
          }
          return response;
        });
      });
    })
  );
});

self.addEventListener("activate", (event) => {
  event.waitUntil(
    caches.keys().then((keys) => Promise.allSettled(
      keys.map((key) => {
        try {
          const data = JSON.parse(key);
          if (data && data["name"] && data.name == GAME_NAME &&
              data.version && data.version != GAME_VERSION) {
            return caches.delete(key);
          }
        } catch {
          return;
        }
      })
    )).then(() => {
    })
  );
});

self.addEventListener("activate", (event) => {
  event.waitUntil(self.clients.claim());
});
