/*
 * Decompiled with CFR 0.152.
 */
package dev.wendigodrip.thebrokenscript.api.entity.base;

import dev.wendigodrip.thebrokenscript.TheBrokenScript;
import dev.wendigodrip.thebrokenscript.api.ext.BlockExt;
import dev.wendigodrip.thebrokenscript.api.ext.BoundingBoxExt;
import dev.wendigodrip.thebrokenscript.api.ext.EntityExt;
import dev.wendigodrip.thebrokenscript.api.queue.QueuedTask;
import dev.wendigodrip.thebrokenscript.registry.TBSTags;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\u001a\u001a\u00020\t*\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0014\u0010\u001e\u001a\u00020\t*\u0004\u0018\u00010\u001b2\u0006\u0010\u001f\u001a\u00020\u001bJ\u0010\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#J\u001a\u0010$\u001a\u00020%2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020%0'J\u0010\u0010)\u001a\u00020%2\b\b\u0002\u0010&\u001a\u00020*R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u0018\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0015\u00a8\u0006+"}, d2={"Ldev/wendigodrip/thebrokenscript/api/entity/base/BaseMonster;", "Lnet/minecraft/world/entity/monster/Monster;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "onSurface", "", "getOnSurface", "()Z", "getLevel", "()Lnet/minecraft/world/level/Level;", "blockPos", "Lnet/minecraft/core/BlockPos;", "getBlockPos", "()Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/phys/Vec3;", "getPos", "()Lnet/minecraft/world/phys/Vec3;", "eyePos", "getEyePos", "viewVector", "getViewVector", "isWithin", "Lnet/minecraft/world/entity/Entity;", "dist", "", "isCloserThan", "other", "queueDiscard", "Ldev/wendigodrip/thebrokenscript/api/queue/QueuedTask;", "ticks", "", "onServerTick", "", "block", "Lkotlin/Function1;", "Lnet/minecraft/server/level/ServerLevel;", "enableWaterWalking", "Lnet/minecraft/world/level/block/Block;", "thebrokenscript"})
public abstract class BaseMonster
extends Monster {
    public BaseMonster(@NotNull EntityType<? extends Monster> entityType, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(entityType, level);
    }

    public final boolean getOnSurface() {
        return this.level().canSeeSkyFromBelowWater(this.blockPosition());
    }

    @NotNull
    public final Level getLevel() {
        Level level = this.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        return level;
    }

    @NotNull
    public final BlockPos getBlockPos() {
        BlockPos blockPos = this.blockPosition();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPosition(...)");
        return blockPos;
    }

    @NotNull
    public final Vec3 getPos() {
        Vec3 vec3 = this.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        return vec3;
    }

    @NotNull
    public final Vec3 getEyePos() {
        Vec3 vec3 = this.getEyePosition(1.0f);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getEyePosition(...)");
        return vec3;
    }

    @NotNull
    public final Vec3 getViewVector() {
        Vec3 vec3 = this.getViewVector(1.0f);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getViewVector(...)");
        return vec3;
    }

    public final boolean isWithin(@Nullable Entity $this$isWithin, @NotNull Number dist) {
        Intrinsics.checkNotNullParameter((Object)dist, (String)"dist");
        return EntityExt.INSTANCE.isWithin($this$isWithin, this.getPos(), dist);
    }

    public final boolean isCloserThan(@Nullable Entity $this$isCloserThan, @NotNull Entity other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.distanceToSqr(this.getPos()) < other.distanceToSqr(this.getPos());
    }

    @Nullable
    public final QueuedTask queueDiscard(int ticks) {
        return TheBrokenScript.INSTANCE.queueServerWork$thebrokenscript(ticks, () -> ((BaseMonster)this).discard());
    }

    public final void onServerTick(@NotNull Function1<? super ServerLevel, Unit> block) {
        block0: {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            super.baseTick();
            Level level = this.getLevel();
            ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
            if (serverLevel == null) break block0;
            block.invoke((Object)serverLevel);
        }
    }

    public final void enableWaterWalking(@NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        while (this.getLevel().getBlockState(this.getBlockPos()).is(Blocks.WATER) || this.getLevel().getBlockState(this.getBlockPos()).is(Blocks.LAVA)) {
            Entity entity = (Entity)this;
            BlockPos blockPos = this.getBlockPos().above();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"above(...)");
            EntityExt.INSTANCE.teleport(entity, blockPos);
        }
        BoundingBox boundingBox = new BoundingBox(this.getBlockPos()).inflatedBy(2);
        Intrinsics.checkNotNullExpressionValue((Object)boundingBox, (String)"inflatedBy(...)");
        for (BlockPos pos : BoundingBoxExt.INSTANCE.getPositions(boundingBox)) {
            if (!this.getLevel().getBlockState(pos).is(TBSTags.MOVEMENT_REPLACE)) continue;
            this.getLevel().setBlock(pos, BlockExt.INSTANCE.default(block), 3);
        }
    }

    public static /* synthetic */ void enableWaterWalking$default(BaseMonster baseMonster, Block block, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: enableWaterWalking");
        }
        if ((n & 1) != 0) {
            block = Blocks.COBBLESTONE;
        }
        baseMonster.enableWaterWalking(block);
    }
}

