/*
 * Decompiled with CFR 0.152.
 */
package dev.wendigodrip.thebrokenscript.behaviors;

import dev.wendigodrip.thebrokenscript.api.entity.base.BaseCircuitEntity;
import dev.wendigodrip.thebrokenscript.api.ext.BlockPosExt;
import dev.wendigodrip.thebrokenscript.api.ext.EntityExt;
import dev.wendigodrip.thebrokenscript.api.ext.EntityFinder;
import dev.wendigodrip.thebrokenscript.api.ext.EntityTypeExt;
import dev.wendigodrip.thebrokenscript.api.ext.LevelExt;
import dev.wendigodrip.thebrokenscript.api.ext.PlayerExt;
import dev.wendigodrip.thebrokenscript.api.ext.TagExt;
import dev.wendigodrip.thebrokenscript.entity.circuit.CircuitEntity;
import dev.wendigodrip.thebrokenscript.entity.circuit.CircuitMineshaftStareEntity;
import dev.wendigodrip.thebrokenscript.entity.circuit.CircuitMineshaftWalkEntity;
import dev.wendigodrip.thebrokenscript.entity.circuit.CircuitStareEntity;
import dev.wendigodrip.thebrokenscript.registry.TBSEntities;
import dev.wendigodrip.thebrokenscript.registry.TBSSounds;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Ldev/wendigodrip/thebrokenscript/behaviors/CircuitStalkBehavior;", "", "<init>", "()V", "tick", "", "level", "Lnet/minecraft/server/level/ServerLevel;", "pos", "Lnet/minecraft/world/phys/Vec3;", "entity", "Ldev/wendigodrip/thebrokenscript/api/entity/base/BaseCircuitEntity;", "thebrokenscript"})
public final class CircuitStalkBehavior {
    @NotNull
    public static final CircuitStalkBehavior INSTANCE = new CircuitStalkBehavior();

    private CircuitStalkBehavior() {
    }

    public final void tick(@NotNull ServerLevel level, @NotNull Vec3 pos, @NotNull BaseCircuitEntity entity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        ServerPlayer serverPlayer = EntityFinder.INSTANCE.findClosestPlayerInRange(level, pos, (Number)2100);
        if (serverPlayer == null) {
            return;
        }
        ServerPlayer player = serverPlayer;
        if (EntityExt.INSTANCE.isWithin((Entity)player, pos, 10) && PlayerExt.INSTANCE.isLookingAt((Player)player, (Entity)entity)) {
            if (level.random.nextBoolean()) {
                entity.discard();
                player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 500, 1, false, false, false));
                Level level2 = (Level)level;
                Object object = SoundEvents.AMBIENT_CAVE.value();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value(...)");
                LevelExt.tryPlaySound$default(LevelExt.INSTANCE, level2, pos, (SoundEvent)object, 555.0f, 0.0f, null, 16, null);
                if (!level.canSeeSkyFromBelowWater(player.blockPosition())) {
                    BlockHitResult rayCast = level.clip(new ClipContext(player.getEyePosition(1.0f), player.getEyePosition(1.0f).add(player.getViewVector(1.0f).scale(-10.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
                    Object object2 = TBSEntities.getCIRCUIT().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                    EntityType entityType = (EntityType)object2;
                    LevelAccessor levelAccessor = (LevelAccessor)level;
                    BlockPos blockPos = rayCast.getBlockPos();
                    Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
                    EntityExt.INSTANCE.applyRandomRotation(EntityTypeExt.INSTANCE.trySummon(entityType, levelAccessor, BlockPosExt.INSTANCE.withY(blockPos, player.getY())));
                }
            } else if ((double)level.random.nextFloat() < 0.7) {
                Object object = TBSEntities.getCIRCUIT().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                EntityExt.INSTANCE.applyRandomRotation(EntityTypeExt.INSTANCE.trySummon((EntityType)object, (LevelAccessor)level, pos));
                player.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 60, 1, false, false));
                entity.discard();
            } else {
                entity.discard();
                Object object = TBSEntities.getCURVED().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                EntityExt.INSTANCE.applyRandomRotation(EntityTypeExt.INSTANCE.trySummon((EntityType)object, (LevelAccessor)level, pos));
                player.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 60, 1, false, false));
            }
        }
        entity.setTarget((LivingEntity)player);
        if (entity instanceof CircuitStareEntity || entity instanceof CircuitMineshaftStareEntity) {
            entity.lookAt(EntityAnchorArgument.Anchor.EYES, player.position());
            if (EntityExt.INSTANCE.isWithin((Entity)player, pos, 200) && entity instanceof CircuitMineshaftStareEntity && PlayerExt.INSTANCE.isLookingAt((Player)player, (Entity)entity)) {
                PlayerExt.INSTANCE.trySendOverlay((Player)player, "textures/screens/blick.png", 10);
                entity.discard();
                LevelAccessor levelAccessor = (LevelAccessor)level;
                Vec3 vec3 = entity.getPos();
                Object object = TBSSounds.YOU_KNOW_NOTHING.get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                LevelExt.playSound$default(LevelExt.INSTANCE, levelAccessor, vec3, (SoundEvent)object, 666.0f, 0.0f, null, 16, null);
            }
        }
        if (entity instanceof CircuitMineshaftWalkEntity && !(entity instanceof CircuitMineshaftStareEntity)) {
            entity.lookAt(EntityAnchorArgument.Anchor.EYES, player.position());
            CompoundTag compoundTag = ((CircuitMineshaftWalkEntity)entity).getPersistentData();
            Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"getPersistentData(...)");
            if (TagExt.INSTANCE.incDouble(compoundTag, "distance") > 145.0) {
                ((CircuitMineshaftWalkEntity)entity).getPersistentData().putDouble("distance", 0.0);
            }
            if (EntityExt.INSTANCE.isWithin((Entity)player, pos, 150.0) && PlayerExt.INSTANCE.isLookingAt((Player)player, (Entity)entity)) {
                Class[] classArray = new Class[]{CircuitEntity.class};
                if (!EntityFinder.INSTANCE.hasEntitiesInRangeExcluding((LevelAccessor)level, (Entity)entity, pos, 20, classArray)) {
                    entity.discard();
                    Object object = TBSEntities.getCIRCUIT_MINESHAFT_FLEE().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                    EntityExt.INSTANCE.applyRandomRotation(EntityTypeExt.INSTANCE.trySummon((EntityType)object, (LevelAccessor)level, pos));
                }
            }
        }
    }
}

