/*
 * Decompiled with CFR 0.152.
 */
package dev.wendigodrip.thebrokenscript.entity.misc;

import com.tterrag.registrate.util.entry.EntityEntry;
import dev.wendigodrip.thebrokenscript.api.entity.FinalizedSpawn;
import dev.wendigodrip.thebrokenscript.api.entity.base.BaseMonster;
import dev.wendigodrip.thebrokenscript.api.ext.EntityExt;
import dev.wendigodrip.thebrokenscript.api.ext.EntityTypeExt;
import dev.wendigodrip.thebrokenscript.api.ext.LevelExt;
import dev.wendigodrip.thebrokenscript.config.TBSConfigs;
import dev.wendigodrip.thebrokenscript.registry.TBSEntities;
import dev.wendigodrip.thebrokenscript.vars.MapVariables;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ4\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Ldev/wendigodrip/thebrokenscript/entity/misc/EntitySpawnerEntity;", "Ldev/wendigodrip/thebrokenscript/api/entity/base/BaseMonster;", "Ldev/wendigodrip/thebrokenscript/api/entity/FinalizedSpawn;", "type", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "onFinalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnType", "Lnet/minecraft/world/entity/MobSpawnType;", "spawnData", "event", "Lnet/neoforged/neoforge/event/entity/living/FinalizeSpawnEvent;", "baseTick", "", "thebrokenscript"})
public final class EntitySpawnerEntity
extends BaseMonster
implements FinalizedSpawn {
    public EntitySpawnerEntity(@NotNull EntityType<EntitySpawnerEntity> type, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(type, level);
    }

    @Override
    @Nullable
    public SpawnGroupData onFinalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnData, @NotNull FinalizeSpawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnType, (String)"spawnType");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        int phase = level.dimensionType().moonPhase(level.dayTime());
        MapVariables vars = LevelExt.INSTANCE.getVars((LevelAccessor)level);
        if (phase != 1 && !TBSConfigs.COMMON.getDanger().getDisableSpawningEntities() && this.getOnSurface() && (double)this.random.nextFloat() >= 0.95 && !vars.getHasSpawnedEntity()) {
            vars.setHasSpawnedEntity(true);
            vars.syncData((LevelAccessor)level);
            Object[] objectArray = new EntityEntry[]{TBSEntities.getNULL_FLYING(), TBSEntities.getNULL_WATCHING(), TBSEntities.getSILUET(), TBSEntities.getSILUET_STARE(), TBSEntities.getDECEIVER(), TBSEntities.getFOLLOW(), TBSEntities.getHE(), TBSEntities.getFARAWAY(), TBSEntities.getNOTHING_IS_WATCHING(), TBSEntities.getCIRCUIT_DISGUISED_AS_CREEPER(), TBSEntities.getPIG_CIRCUIT(), TBSEntities.getHETZER()};
            List entities = CollectionsKt.mutableListOf((Object[])objectArray);
            if (vars.getMoonPhase() == 2) {
                entities.add(TBSEntities.getTHE_BROKEN_END_OVERHAUL_STALK());
            }
            Object object = ((EntityEntry)CollectionsKt.random((Collection)entities, (Random)((Random)Random.Default))).get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            EntityExt.INSTANCE.applyRandomRotation(EntityTypeExt.INSTANCE.trySummon((EntityType)object, (LevelAccessor)level, this.getPos()));
        }
        event.setSpawnCancelled(true);
        return null;
    }

    public void baseTick() {
        super.baseTick();
        if (!this.isRemoved()) {
            this.discard();
        }
    }

    @Override
    public void callFinalizeSpawn(@NotNull FinalizeSpawnEvent event) {
        FinalizedSpawn.DefaultImpls.callFinalizeSpawn(this, event);
    }
}

