/*
 * Decompiled with CFR 0.152.
 */
package dev.wendigodrip.thebrokenscript.entity.nullent;

import dev.wendigodrip.thebrokenscript.api.entity.FinalizedSpawn;
import dev.wendigodrip.thebrokenscript.api.entity.base.BaseMonster;
import dev.wendigodrip.thebrokenscript.api.ext.EntityExt;
import dev.wendigodrip.thebrokenscript.api.ext.EntityFinder;
import dev.wendigodrip.thebrokenscript.api.ext.EntityTypeExt;
import dev.wendigodrip.thebrokenscript.api.ext.LevelExt;
import dev.wendigodrip.thebrokenscript.api.ext.PlayerExt;
import dev.wendigodrip.thebrokenscript.api.util.Vectors;
import dev.wendigodrip.thebrokenscript.registry.TBSDimensions;
import dev.wendigodrip.thebrokenscript.registry.TBSEntities;
import dev.wendigodrip.thebrokenscript.registry.TBSParticleTypes;
import dev.wendigodrip.thebrokenscript.registry.TBSSounds;
import dev.wendigodrip.thebrokenscript.vars.PlayerVariables;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0001\"B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016J\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J4\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0005\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\nH\u0016J\u0010\u0010 \u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020!H\u0016\u00a8\u0006#"}, d2={"Ldev/wendigodrip/thebrokenscript/entity/nullent/NullWatchingEntity;", "Ldev/wendigodrip/thebrokenscript/api/entity/base/BaseMonster;", "Ldev/wendigodrip/thebrokenscript/api/entity/FinalizedSpawn;", "type", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "registerGoals", "", "removeWhenFarAway", "", "distanceToClosestPlayer", "", "fireImmune", "hurt", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "amount", "", "onFinalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnType", "Lnet/minecraft/world/entity/MobSpawnType;", "spawnData", "event", "Lnet/neoforged/neoforge/event/entity/living/FinalizeSpawnEvent;", "baseTick", "isPushedByFluid", "Lnet/neoforged/neoforge/fluids/FluidType;", "Companion", "thebrokenscript"})
public final class NullWatchingEntity
extends BaseMonster
implements FinalizedSpawn {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public NullWatchingEntity(@NotNull EntityType<NullWatchingEntity> type, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(type, level);
        this.xpReward = 10;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new FloatGoal((Mob)this));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return Intrinsics.areEqual((Object)source.type(), (Object)DamageTypes.GENERIC_KILL) || Intrinsics.areEqual((Object)source.type(), (Object)DamageTypes.FELL_OUT_OF_WORLD);
    }

    @Override
    @Nullable
    public SpawnGroupData onFinalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnData, @NotNull FinalizeSpawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnType, (String)"spawnType");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LevelAccessor levelAccessor = (LevelAccessor)level;
        Vec3 vec3 = new Vec3(this.getX(), this.getY(), this.getZ());
        Object object = SoundEvents.AMBIENT_CAVE.value();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value(...)");
        LevelExt.playSound$default(LevelExt.INSTANCE, levelAccessor, vec3, (SoundEvent)object, 555.0f, 0.0f, null, 16, null);
        return null;
    }

    public void baseTick() {
        super.baseTick();
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerPlayer player = EntityFinder.INSTANCE.findClosestPlayerInRange((ServerLevel)level, new Vec3(this.getX(), this.getY(), this.getZ()), (Number)400.0);
        if (player != null) {
            this.lookAt(EntityAnchorArgument.Anchor.EYES, player.position());
        }
        IronGolem ironGolem = EntityFinder.INSTANCE.findClosestEntityInRange((LevelAccessor)level, IronGolem.class, this.getPos(), 10);
        if (ironGolem != null) {
            ironGolem.hurt(((ServerLevel)level).damageSources().generic(), 55.0f);
        }
        if (player != null && EntityExt.INSTANCE.isWithin((Entity)player, this.getPos(), 20)) {
            PlayerVariables vars = PlayerExt.INSTANCE.getVars((Player)player);
            int angerType = this.random.nextInt(1, 10);
            if (angerType == 1) {
                this.discard();
                player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 80, 1, false, false));
                PlayerExt.sendSound$default(PlayerExt.INSTANCE, player, (Holder)TBSSounds.NULL_FLEE, 555.0f, 0.0f, null, null, 0L, 60, null);
            } else if (angerType == 2 && vars.getEntityReputation() != 2) {
                this.discard();
                Object object = TBSEntities.getNULL_CHASE().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                EntityExt.INSTANCE.applyRandomRotation(EntityTypeExt.INSTANCE.trySummon((EntityType)object, (LevelAccessor)level, this.getPos()));
                player.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 50, 1, false, false));
            } else if (angerType == 3) {
                this.discard();
                if (vars.getEntityReputation() == 0) {
                    Object object = TBSEntities.getNULL_UNBEATABLE_BOSSFIGHT().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                    v3 = EntityExt.INSTANCE.applyRandomRotation(EntityTypeExt.INSTANCE.trySummon((EntityType)object, (LevelAccessor)level, this.getPos()));
                } else {
                    Object object = TBSEntities.getNULL_CHASE().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                    v3 = EntityExt.INSTANCE.applyRandomRotation(EntityTypeExt.INSTANCE.trySummon((EntityType)object, (LevelAccessor)level, this.getPos()));
                }
            } else if (angerType == 4) {
                this.discard();
                LevelExt.INSTANCE.sendParticles((ServerLevel)level, (Supplier)TBSParticleTypes.NULL_PARTICLE, this.getPos(), (Number)50, Vectors.INSTANCE.all(3), (Number)0);
            } else if (angerType == 5) {
                this.discard();
                LevelExt.INSTANCE.sendParticles((ServerLevel)level, (Supplier)TBSParticleTypes.EYES, this.getPos(), (Number)50, Vectors.INSTANCE.all(3), (Number)0);
            } else if (angerType == 6) {
                this.discard();
                LevelExt.INSTANCE.sendParticles((ServerLevel)level, (Supplier)TBSParticleTypes.NULL_PARTICLE, this.getPos(), (Number)50, Vectors.INSTANCE.all(3), (Number)0);
                PlayerExt.INSTANCE.sendTo((Player)player, TBSDimensions.NULL_TORTURE);
            } else if (angerType == 7) {
                this.discard();
                LevelExt.INSTANCE.sendParticles((ServerLevel)level, (Supplier)TBSParticleTypes.NULL_PARTICLE, this.getPos(), (Number)50, Vectors.INSTANCE.all(3), (Number)0);
                PlayerExt.INSTANCE.sendTo((Player)player, TBSDimensions.DAY_B);
            } else if (angerType == 8) {
                this.discard();
                LevelExt.INSTANCE.sendParticles((ServerLevel)level, (Supplier)TBSParticleTypes.NULL_PARTICLE, this.getPos(), (Number)50, Vectors.INSTANCE.all(3), (Number)0);
                this.teleportTo(vars.getBasePos().getCenter().x, vars.getBasePos().getCenter().y + 1.0, vars.getBasePos().getCenter().z);
            } else if (angerType == 9) {
                this.discard();
                LevelExt.INSTANCE.sendParticles((ServerLevel)level, (Supplier)TBSParticleTypes.NULL_PARTICLE, this.getPos(), (Number)50, Vectors.INSTANCE.all(3), (Number)0);
                player.teleportTo(vars.getBasePos().getCenter().x, vars.getBasePos().getCenter().y + 1.0, vars.getBasePos().getCenter().z);
            } else if (angerType == 10) {
                this.discard();
                EntityType entityType = EntityType.LIGHTNING_BOLT;
                Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"LIGHTNING_BOLT");
                EntityTypeExt.INSTANCE.trySummon(entityType, (LevelAccessor)level, this.getPos());
            }
        }
        if (((ServerLevel)level).isDay()) {
            this.discard();
        }
    }

    public boolean isPushedByFluid(@NotNull FluidType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return false;
    }

    @Override
    public void callFinalizeSpawn(@NotNull FinalizeSpawnEvent event) {
        FinalizedSpawn.DefaultImpls.callFinalizeSpawn(this, event);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Ldev/wendigodrip/thebrokenscript/entity/nullent/NullWatchingEntity$Companion;", "", "<init>", "()V", "createAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "thebrokenscript"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier.Builder createAttributes() {
            AttributeSupplier.Builder builder = Monster.createMobAttributes();
            builder = builder.add(Attributes.MOVEMENT_SPEED, 0.0);
            builder = builder.add(Attributes.MAX_HEALTH, 910.0);
            builder = builder.add(Attributes.ARMOR, 10.0);
            builder = builder.add(Attributes.ATTACK_DAMAGE, 63.0);
            builder = builder.add(Attributes.FOLLOW_RANGE, 916.0);
            builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 10.0);
            AttributeSupplier.Builder builder2 = builder = builder.add(Attributes.ATTACK_KNOCKBACK, 10.0);
            Intrinsics.checkNotNull((Object)builder2);
            return builder2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

