/*
 * Decompiled with CFR 0.152.
 */
package dev.wendigodrip.thebrokenscript.entity.nullent;

import dev.wendigodrip.thebrokenscript.api.entity.FinalizedSpawn;
import dev.wendigodrip.thebrokenscript.api.entity.base.UwuableMonster;
import dev.wendigodrip.thebrokenscript.api.ext.AttributesExt;
import dev.wendigodrip.thebrokenscript.api.ext.ComponentExt;
import dev.wendigodrip.thebrokenscript.api.ext.EntityExt;
import dev.wendigodrip.thebrokenscript.api.ext.EntityFinder;
import dev.wendigodrip.thebrokenscript.api.ext.EntityTypeExt;
import dev.wendigodrip.thebrokenscript.api.ext.LevelExt;
import dev.wendigodrip.thebrokenscript.api.ext.TagExt;
import dev.wendigodrip.thebrokenscript.api.queue.TypedWorkQueue;
import dev.wendigodrip.thebrokenscript.api.world.TimeOfDay;
import dev.wendigodrip.thebrokenscript.config.TBSConfigs;
import dev.wendigodrip.thebrokenscript.registry.TBSEntities;
import dev.wendigodrip.thebrokenscript.registry.TBSLang;
import dev.wendigodrip.thebrokenscript.vars.MapVariables;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.HexExtensionsKt;
import kotlin.text.StringsKt;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0001\"B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J4\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0005\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\nH\u0016J\u0016\u0010\u001f\u001a\u0004\u0018\u00010 2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030!H\u0016\u00a8\u0006#"}, d2={"Ldev/wendigodrip/thebrokenscript/entity/nullent/Xxram2dieEntity;", "Ldev/wendigodrip/thebrokenscript/api/entity/base/UwuableMonster;", "Ldev/wendigodrip/thebrokenscript/api/entity/FinalizedSpawn;", "type", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "registerGoals", "", "removeWhenFarAway", "", "distanceToClosestPlayer", "", "hurt", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "amount", "", "onFinalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnType", "Lnet/minecraft/world/entity/MobSpawnType;", "spawnData", "event", "Lnet/neoforged/neoforge/event/entity/living/FinalizeSpawnEvent;", "baseTick", "movementPredicate", "Lsoftware/bernie/geckolib/animation/PlayState;", "Lsoftware/bernie/geckolib/animation/AnimationState;", "Companion", "thebrokenscript"})
public final class Xxram2dieEntity
extends UwuableMonster
implements FinalizedSpawn {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public Xxram2dieEntity(@NotNull EntityType<Xxram2dieEntity> type, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(type, level);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setCustomName((Component)TBSLang.INSTANCE.getRAM2DIE_NAME());
        this.setCustomNameVisible(true);
        this.setPersistenceRequired();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new FloatGoal((Mob)this));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return Intrinsics.areEqual((Object)source.type(), (Object)DamageTypes.GENERIC_KILL) || Intrinsics.areEqual((Object)source.type(), (Object)DamageTypes.FELL_OUT_OF_WORLD);
    }

    @Override
    @Nullable
    public SpawnGroupData onFinalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnData, @NotNull FinalizeSpawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnType, (String)"spawnType");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MapVariables vars = LevelExt.INSTANCE.getVars((LevelAccessor)level);
        if (vars.getHasTriggeredRam2Die() && !vars.getHasRam2DieJoined() && level.canSeeSkyFromBelowWater(this.blockPosition())) {
            vars.setHasRam2DieJoined(true);
            vars.syncData((LevelAccessor)this.getLevel());
            TypedWorkQueue<ServerLevelAccessor> queue = new TypedWorkQueue<ServerLevelAccessor>();
            queue.add(1, Xxram2dieEntity::onFinalizeSpawn$lambda$0);
            queue.add(500, arg_0 -> Xxram2dieEntity.onFinalizeSpawn$lambda$1(level, this, arg_0));
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Hello?", (Object)1000), TuplesKt.to((Object)"How did you found this server?", (Object)500), TuplesKt.to((Object)"Do you want to be friends?", (Object)500), TuplesKt.to((Object)"Leave.", (Object)500)};
            Map messages = MapsKt.mapOf((Pair[])pairArray);
            for (Map.Entry entry : messages.entrySet()) {
                String msg = (String)entry.getKey();
                int delay = ((Number)entry.getValue()).intValue();
                queue.add(delay, arg_0 -> Xxram2dieEntity.onFinalizeSpawn$lambda$2(msg, this, arg_0));
            }
            queue.add(500, arg_0 -> Xxram2dieEntity.onFinalizeSpawn$lambda$3(this, arg_0));
            queue.start(level);
        } else {
            event.setSpawnCancelled(true);
        }
        return null;
    }

    public void baseTick() {
        super.baseTick();
        Level level = this.level();
        Vec3 pos = this.position();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        if (((ServerLevel)level).isDay()) {
            this.discard();
        }
        if (((ServerLevel)level).getBlockState(this.blockPosition()).canOcclude()) {
            Entity entity = (Entity)this;
            Vec3 vec3 = pos.add(0.0, 1.0, 0.0);
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
            EntityExt.INSTANCE.teleport(entity, vec3);
        }
        LevelAccessor levelAccessor = (LevelAccessor)level;
        Intrinsics.checkNotNull((Object)pos);
        Player player = EntityFinder.INSTANCE.findClosestEntityInRange(levelAccessor, Player.class, pos, 4000.0);
        if (player != null) {
            this.lookAt(EntityAnchorArgument.Anchor.EYES, player.position().add(0.0, 1.0, 0.0));
            if (EntityExt.INSTANCE.isWithin((Entity)player, pos, 40.0)) {
                BlockHitResult rayCast = ((ServerLevel)level).clip(new ClipContext(player.getEyePosition(1.0f), player.getEyePosition(1.0f).add(player.getViewVector(1.0f).scale(-42.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
                this.teleportTo(rayCast.getBlockPos().getX(), pos.y, rayCast.getBlockPos().getZ());
                CompoundTag compoundTag = this.getPersistentData();
                Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"getPersistentData(...)");
                if (TagExt.INSTANCE.incInt(compoundTag, "Anger") != 3) {
                    this.discard();
                    if ((double)this.random.nextFloat() < 0.7) {
                        Object object = TBSEntities.getNULL_CHASE().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                        EntityExt.INSTANCE.applyRandomRotation(EntityTypeExt.INSTANCE.trySummon((EntityType)object, (LevelAccessor)level, this.getPos()));
                    } else if (!TBSConfigs.COMMON.getDisableBanning()) {
                        Object object = TBSEntities.getBAN().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                        EntityExt.INSTANCE.applyRandomRotation(EntityTypeExt.INSTANCE.trySummon((EntityType)object, (LevelAccessor)level, this.getPos()));
                    }
                }
            }
        }
        this.refreshDimensions();
    }

    @Override
    @Nullable
    public PlayState movementPredicate(@NotNull AnimationState<?> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        if (Intrinsics.areEqual((Object)this.getAnimProcedure(), (Object)"empty")) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("a"));
        }
        return PlayState.STOP;
    }

    @Override
    public void callFinalizeSpawn(@NotNull FinalizeSpawnEvent event) {
        FinalizedSpawn.DefaultImpls.callFinalizeSpawn(this, event);
    }

    private static final Unit onFinalizeSpawn$lambda$0(ServerLevelAccessor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LevelExt.chat$default(LevelExt.INSTANCE, (LevelAccessor)it, (Component)TBSLang.INSTANCE.getRAM2DIE_HOSTED(), false, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit onFinalizeSpawn$lambda$1(ServerLevelAccessor $level, Xxram2dieEntity this$0, ServerLevelAccessor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LevelExt.chat$default(LevelExt.INSTANCE, (LevelAccessor)it, (Component)TBSLang.INSTANCE.getRAM2DIE_JOIN(), false, 2, null);
        TimeOfDay.MIDNIGHT.setFake();
        LevelAccessor levelAccessor = (LevelAccessor)$level;
        Vec3 vec3 = this$0.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        Object object = SoundEvents.AMBIENT_CAVE.value();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value(...)");
        LevelExt.playSound$default(LevelExt.INSTANCE, levelAccessor, vec3, (SoundEvent)object, 555.0f, 0.0f, null, 16, null);
        return Unit.INSTANCE;
    }

    private static final Unit onFinalizeSpawn$lambda$2(String $msg, Xxram2dieEntity this$0, ServerLevelAccessor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LevelAccessor levelAccessor = (LevelAccessor)it;
        String string = ComponentExt.INSTANCE.getTranslationKey((Component)TBSLang.INSTANCE.getRAM2DIE_CHAT_MSG());
        Intrinsics.checkNotNull((Object)string);
        Object[] objectArray = new Object[]{HexExtensionsKt.toHexString$default((byte[])StringsKt.encodeToByteArray((String)$msg), null, (int)1, null)};
        MutableComponent mutableComponent = Component.translatable((String)string, (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        LevelExt.chat$default(LevelExt.INSTANCE, levelAccessor, (Component)mutableComponent, false, 2, null);
        TimeOfDay.MIDNIGHT.setFake();
        LevelAccessor levelAccessor2 = (LevelAccessor)it;
        Vec3 vec3 = this$0.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        Object object = SoundEvents.AMBIENT_CAVE.value();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value(...)");
        LevelExt.playSound$default(LevelExt.INSTANCE, levelAccessor2, vec3, (SoundEvent)object, 555.0f, 0.0f, null, 16, null);
        return Unit.INSTANCE;
    }

    private static final Unit onFinalizeSpawn$lambda$3(Xxram2dieEntity this$0, ServerLevelAccessor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LevelExt.chat$default(LevelExt.INSTANCE, (LevelAccessor)it, (Component)TBSLang.INSTANCE.getRAM2DIE_LEAVE(), false, 2, null);
        this$0.discard();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Ldev/wendigodrip/thebrokenscript/entity/nullent/Xxram2dieEntity$Companion;", "", "<init>", "()V", "createAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "thebrokenscript"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier.Builder createAttributes() {
            AttributeSupplier.Builder builder = Monster.createMobAttributes();
            builder = builder.add(Attributes.MOVEMENT_SPEED, 0.0);
            builder = builder.add(Attributes.MAX_HEALTH, 710.0);
            builder = builder.add(Attributes.ARMOR, 0.0);
            builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
            AttributeSupplier.Builder builder2 = builder.add(Attributes.FOLLOW_RANGE, 916.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"add(...)");
            builder = AttributesExt.INSTANCE.stepHeight(builder2, 10.6);
            return builder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

