/*
 * Decompiled with CFR 0.152.
 */
package dev.wendigodrip.thebrokenscript.entity.siluet;

import dev.wendigodrip.thebrokenscript.TheBrokenScript;
import dev.wendigodrip.thebrokenscript.api.entity.FinalizedSpawn;
import dev.wendigodrip.thebrokenscript.api.entity.base.BaseMonster;
import dev.wendigodrip.thebrokenscript.api.entity.base.BaseSiluetEntity;
import dev.wendigodrip.thebrokenscript.api.ext.AttributesExt;
import dev.wendigodrip.thebrokenscript.api.ext.EntityExt;
import dev.wendigodrip.thebrokenscript.api.ext.EntityFinder;
import dev.wendigodrip.thebrokenscript.api.ext.EntityTypeExt;
import dev.wendigodrip.thebrokenscript.api.ext.LevelExt;
import dev.wendigodrip.thebrokenscript.api.ext.PlayerExt;
import dev.wendigodrip.thebrokenscript.registry.TBSAdvancements;
import dev.wendigodrip.thebrokenscript.registry.TBSEntities;
import dev.wendigodrip.thebrokenscript.registry.TBSParticleTypes;
import dev.wendigodrip.thebrokenscript.registry.TBSSounds;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0001\u0019B\u001f\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014J4\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\nH\u0016J\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0016\u00a8\u0006\u001a"}, d2={"Ldev/wendigodrip/thebrokenscript/entity/siluet/SiluetEntity;", "Ldev/wendigodrip/thebrokenscript/api/entity/base/BaseSiluetEntity;", "Ldev/wendigodrip/thebrokenscript/api/entity/FinalizedSpawn;", "type", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "registerGoals", "", "onFinalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnType", "Lnet/minecraft/world/entity/MobSpawnType;", "spawnData", "event", "Lnet/neoforged/neoforge/event/entity/living/FinalizeSpawnEvent;", "baseTick", "movementPredicate", "Lsoftware/bernie/geckolib/animation/PlayState;", "Lsoftware/bernie/geckolib/animation/AnimationState;", "Companion", "thebrokenscript"})
public class SiluetEntity
extends BaseSiluetEntity
implements FinalizedSpawn {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public SiluetEntity(@NotNull EntityType<? extends SiluetEntity> type, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super((EntityType<? extends BaseSiluetEntity>)type, level);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new FloatGoal((Mob)this));
    }

    @Override
    @Nullable
    public SpawnGroupData onFinalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnData, @NotNull FinalizeSpawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnType, (String)"spawnType");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.getOnSurface()) {
            if ((double)this.random.nextFloat() < 0.7) {
                event.setSpawnCancelled(true);
            } else {
                Player player;
                LevelAccessor levelAccessor = (LevelAccessor)level;
                Vec3 vec3 = this.getPos();
                Object object = SoundEvents.AMBIENT_CAVE.value();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value(...)");
                LevelExt.playSound$default(LevelExt.INSTANCE, levelAccessor, vec3, (SoundEvent)object, 555.0f, 1.0f, null, 16, null);
                if ((double)this.random.nextFloat() < 0.9 && (player = EntityFinder.INSTANCE.findClosestEntityInRange((LevelAccessor)level, Player.class, this.getPos(), 1000.0)) != null) {
                    ResourceLocation resourceLocation = TBSAdvancements.CAN_YOU_SEE_ME.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getId(...)");
                    PlayerExt.INSTANCE.awardAdvancement(player, resourceLocation);
                }
                TheBrokenScript.INSTANCE.queueServerWork$thebrokenscript(18000, () -> SiluetEntity.onFinalizeSpawn$lambda$0(this, level));
            }
        } else {
            event.setSpawnCancelled(true);
        }
        return null;
    }

    public void baseTick() {
        super.baseTick();
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        BaseMonster.enableWaterWalking$default(this, null, 1, null);
        ServerPlayer player = EntityFinder.INSTANCE.findClosestPlayerInRange((ServerLevel)level, this.getPos(), (Number)1000.0);
        if (player != null) {
            this.lookAt(EntityAnchorArgument.Anchor.EYES, player.position());
            if (this.isWithin((Entity)player, 20.0) && PlayerExt.INSTANCE.isLookingAt((Player)player, (Entity)this)) {
                this.discard();
                player.lookAt(EntityAnchorArgument.Anchor.EYES, this.getPos().add(0.0, 1.0, 0.0));
                if (this.random.nextBoolean()) {
                    if (this.getOnSurface()) {
                        EntityType entityType = EntityType.LIGHTNING_BOLT;
                        Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"LIGHTNING_BOLT");
                        LevelAccessor levelAccessor = (LevelAccessor)level;
                        Vec3 vec3 = player.position();
                        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
                        EntityTypeExt.INSTANCE.trySummon(entityType, levelAccessor, vec3);
                    }
                    Object object = TBSEntities.getSILUET_CHASE().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                    EntityExt.INSTANCE.applyRandomRotation(EntityTypeExt.INSTANCE.trySummon((EntityType)object, (LevelAccessor)level, this.getPos()));
                } else {
                    Object object = TBSSounds.TEXT_MADNESS_1.get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                    PlayerExt.sendSound$default(PlayerExt.INSTANCE, player, (SoundEvent)object, 555.0f, 0.0f, null, null, 0L, 60, null);
                    PlayerExt.INSTANCE.trySendOverlay((Player)player, "textures/screens/cantyousee.png", 10);
                }
            }
        }
        if (((ServerLevel)level).isDay()) {
            this.discard();
            ((ServerLevel)level).sendParticles((ParticleOptions)TBSParticleTypes.NULL_PARTICLE.get(), this.getX(), this.getY(), this.getZ(), 50, 3.0, 3.0, 3.0, 0.0);
        }
        this.refreshDimensions();
    }

    @Override
    @Nullable
    public PlayState movementPredicate(@NotNull AnimationState<?> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        if (Intrinsics.areEqual((Object)this.getAnimProcedure(), (Object)"empty")) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.STOP;
    }

    @Override
    public void callFinalizeSpawn(@NotNull FinalizeSpawnEvent event) {
        FinalizedSpawn.DefaultImpls.callFinalizeSpawn(this, event);
    }

    private static final void onFinalizeSpawn$lambda$0(SiluetEntity this$0, ServerLevelAccessor $level) {
        this$0.discard();
        if ((double)this$0.random.nextFloat() < 0.01) {
            Object object = TBSEntities.getSILUET_CHASE().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            EntityExt.INSTANCE.applyRandomRotation(EntityTypeExt.INSTANCE.trySummon((EntityType)object, (LevelAccessor)$level, this$0.getPos()));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Ldev/wendigodrip/thebrokenscript/entity/siluet/SiluetEntity$Companion;", "", "<init>", "()V", "createAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "thebrokenscript"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier.Builder createAttributes() {
            AttributeSupplier.Builder builder = Monster.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.MAX_HEALTH, 10.0).add(Attributes.ARMOR, 0.0).add(Attributes.ATTACK_DAMAGE, 13.0).add(Attributes.FOLLOW_RANGE, 590.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return AttributesExt.INSTANCE.stepHeight(builder, 10.6);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

