/*
 * Decompiled with CFR 0.152.
 */
package dev.wendigodrip.thebrokenscript.entity.tbe;

import dev.wendigodrip.thebrokenscript.TheBrokenScript;
import dev.wendigodrip.thebrokenscript.api.entity.FinalizedSpawn;
import dev.wendigodrip.thebrokenscript.api.entity.base.UwuableMonster;
import dev.wendigodrip.thebrokenscript.api.ext.EntityExt;
import dev.wendigodrip.thebrokenscript.api.ext.EntityFinder;
import dev.wendigodrip.thebrokenscript.api.ext.EntityTypeExt;
import dev.wendigodrip.thebrokenscript.api.ext.LevelExt;
import dev.wendigodrip.thebrokenscript.registry.TBSEntities;
import dev.wendigodrip.thebrokenscript.registry.TBSSounds;
import dev.wendigodrip.thebrokenscript.vars.MapVariables;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 #2\u00020\u00012\u00020\u0002:\u0001#B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J4\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0005\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\nH\u0016J\u0016\u0010\u001f\u001a\u0004\u0018\u00010 2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030!H\u0016J\b\u0010\"\u001a\u00020\nH\u0014\u00a8\u0006$"}, d2={"Ldev/wendigodrip/thebrokenscript/entity/tbe/TheBrokenEndStalkkEntity;", "Ldev/wendigodrip/thebrokenscript/api/entity/base/UwuableMonster;", "Ldev/wendigodrip/thebrokenscript/api/entity/FinalizedSpawn;", "type", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "registerGoals", "", "removeWhenFarAway", "", "distanceToClosestPlayer", "", "hurt", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "amount", "", "onFinalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnType", "Lnet/minecraft/world/entity/MobSpawnType;", "spawnData", "event", "Lnet/neoforged/neoforge/event/entity/living/FinalizeSpawnEvent;", "baseTick", "movementPredicate", "Lsoftware/bernie/geckolib/animation/PlayState;", "Lsoftware/bernie/geckolib/animation/AnimationState;", "tickDeath", "Companion", "thebrokenscript"})
public final class TheBrokenEndStalkkEntity
extends UwuableMonster
implements FinalizedSpawn {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public TheBrokenEndStalkkEntity(@NotNull EntityType<TheBrokenEndStalkkEntity> type, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(type, level);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new FloatGoal((Mob)this));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return Intrinsics.areEqual((Object)source.type(), (Object)DamageTypes.GENERIC_KILL) || Intrinsics.areEqual((Object)source.type(), (Object)DamageTypes.FELL_OUT_OF_WORLD);
    }

    @Override
    @Nullable
    public SpawnGroupData onFinalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnData, @NotNull FinalizeSpawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnType, (String)"spawnType");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        MapVariables vars = LevelExt.INSTANCE.getVars((LevelAccessor)level);
        if (level.canSeeSkyFromBelowWater(BlockPos.containing((double)this.getX(), (double)this.getY(), (double)this.getZ()))) {
            if (((ServerLevel)level).dimensionType().moonPhase(level.dayTime()) > 4 || ((ServerLevel)level).dimensionType().moonPhase(level.dayTime()) == 4) {
                if (vars.getHasTheBrokenEndSpawned()) {
                    event.setSpawnCancelled(true);
                } else {
                    LevelAccessor levelAccessor = (LevelAccessor)level;
                    Vec3 vec3 = new Vec3(this.getX(), this.getY(), this.getZ());
                    Object object = TBSSounds.TREVOGA.get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                    LevelExt.playSound$default(LevelExt.INSTANCE, levelAccessor, vec3, (SoundEvent)object, 555.0f, 0.0f, null, 16, null);
                    vars.setHasTheBrokenEndSpawned(true);
                    vars.syncData((LevelAccessor)level);
                    TheBrokenScript.INSTANCE.queueServerWork$thebrokenscript(18000, () -> TheBrokenEndStalkkEntity.onFinalizeSpawn$lambda$0(this, level));
                }
            } else {
                event.setSpawnCancelled(true);
                LevelAccessor levelAccessor = (LevelAccessor)level;
                Vec3 vec3 = new Vec3(this.getX(), this.getY(), this.getZ());
                Object object = SoundEvents.AMBIENT_CAVE.value();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value(...)");
                LevelExt.playSound$default(LevelExt.INSTANCE, levelAccessor, vec3, (SoundEvent)object, 555.0f, 0.0f, null, 16, null);
            }
        } else {
            event.setSpawnCancelled(true);
        }
        return null;
    }

    public void baseTick() {
        ServerPlayer player;
        super.baseTick();
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        IronGolem ironGolem = EntityFinder.INSTANCE.findClosestEntityInRange((LevelAccessor)level, IronGolem.class, new Vec3(this.getX(), this.getY(), this.getZ()), 20.0);
        if (ironGolem != null) {
            ironGolem.hurt(((ServerLevel)level).damageSources().playerAttack(null), 30.0f);
        }
        if ((ironGolem = EntityFinder.INSTANCE.findClosestEntityInRange((LevelAccessor)level, Boat.class, new Vec3(this.getX(), this.getY(), this.getZ()), 20.0)) != null) {
            ironGolem.hurt(((ServerLevel)level).damageSources().playerAttack(null), 30.0f);
        }
        if ((player = EntityFinder.INSTANCE.findClosestPlayerInRange((ServerLevel)level, new Vec3(this.getX(), this.getY(), this.getZ()), (Number)50.0)) != null) {
            if ((double)this.random.nextFloat() < 0.7) {
                this.discard();
                player.lookAt(EntityAnchorArgument.Anchor.EYES, new Vec3(this.getX(), this.getY(), this.getZ()));
                Object object = TBSEntities.getTHE_BROKEN_END().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                EntityTypeExt.INSTANCE.trySummon((EntityType)object, (LevelAccessor)level, new Vec3(this.getX(), this.getY(), this.getZ()));
            } else if ((double)this.random.nextFloat() < 0.7) {
                this.discard();
                player.lookAt(EntityAnchorArgument.Anchor.EYES, new Vec3(this.getX(), this.getY(), this.getZ()));
                player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 60, 1, false, false));
                if (((ServerLevel)level).canSeeSkyFromBelowWater(BlockPos.containing((Position)((Position)player.position())))) {
                    LightningBolt bolt;
                    LightningBolt lightningBolt = bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(level);
                    Intrinsics.checkNotNull((Object)lightningBolt);
                    lightningBolt.moveTo(player.position());
                    ((ServerLevel)level).addFreshEntity((Entity)bolt);
                }
            } else {
                this.discard();
                player.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 60, 1, false, false));
            }
            this.lookAt(EntityAnchorArgument.Anchor.EYES, player.position());
        }
        this.refreshDimensions();
    }

    @Override
    @Nullable
    public PlayState movementPredicate(@NotNull AnimationState<?> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        if (Intrinsics.areEqual((Object)this.getAnimProcedure(), (Object)"empty")) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.STOP;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 20) {
            this.remove(Entity.RemovalReason.KILLED);
            this.dropExperience((Entity)this);
        }
    }

    @Override
    public void callFinalizeSpawn(@NotNull FinalizeSpawnEvent event) {
        FinalizedSpawn.DefaultImpls.callFinalizeSpawn(this, event);
    }

    private static final void onFinalizeSpawn$lambda$0(TheBrokenEndStalkkEntity this$0, ServerLevelAccessor $level) {
        this$0.discard();
        LevelAccessor levelAccessor = (LevelAccessor)$level;
        Vec3 vec3 = new Vec3(this$0.getX(), this$0.getY(), this$0.getZ());
        SoundEvent soundEvent = SoundEvents.BELL_RESONATE;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"BELL_RESONATE");
        LevelExt.playSound$default(LevelExt.INSTANCE, levelAccessor, vec3, soundEvent, 555.0f, 0.0f, null, 16, null);
        if ((double)this$0.random.nextFloat() < 0.1) {
            Object object = TBSEntities.getTHE_BROKEN_END().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            EntityType entityType = (EntityType)object;
            LevelAccessor levelAccessor2 = (LevelAccessor)$level;
            BlockPos blockPos = BlockPos.containing((double)this$0.getX(), (double)this$0.getY(), (double)this$0.getZ());
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"containing(...)");
            EntityExt.INSTANCE.applyRandomRotation(EntityTypeExt.INSTANCE.trySummon(entityType, levelAccessor2, blockPos));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Ldev/wendigodrip/thebrokenscript/entity/tbe/TheBrokenEndStalkkEntity$Companion;", "", "<init>", "()V", "createAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "thebrokenscript"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier.Builder createAttributes() {
            AttributeSupplier.Builder builder = Monster.createMobAttributes();
            builder = builder.add(Attributes.MOVEMENT_SPEED, 0.0);
            builder = builder.add(Attributes.MAX_HEALTH, 810.0);
            builder = builder.add(Attributes.ARMOR, 0.0);
            builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
            AttributeSupplier.Builder builder2 = builder = builder.add(Attributes.FOLLOW_RANGE, 916.0);
            Intrinsics.checkNotNull((Object)builder2);
            return builder2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

