/*
 * Decompiled with CFR 0.152.
 */
package dev.wendigodrip.thebrokenscript.handlers;

import dev.wendigodrip.thebrokenscript.api.ext.EntityFinder;
import dev.wendigodrip.thebrokenscript.api.ext.LevelExt;
import dev.wendigodrip.thebrokenscript.api.ext.PlayerExt;
import dev.wendigodrip.thebrokenscript.entity.NoTextureEntity;
import dev.wendigodrip.thebrokenscript.entity.nullent.NullFlyingEntity;
import dev.wendigodrip.thebrokenscript.entity.nullent.NullWatchingEntity;
import dev.wendigodrip.thebrokenscript.entity.siluet.SiluetEntity;
import dev.wendigodrip.thebrokenscript.entity.siluet.SiluetStareEntity;
import dev.wendigodrip.thebrokenscript.entity.tbe.TheBrokenEndEntity;
import dev.wendigodrip.thebrokenscript.entity.tbe.TheBrokenEndOverhaulStalkEntity;
import dev.wendigodrip.thebrokenscript.vars.MapVariables;
import dev.wendigodrip.thebrokenscript.vars.PlayerVariables;
import java.lang.constant.Constable;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.CanContinueSleepingEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/wendigodrip/thebrokenscript/handlers/SleepMessageHandler;", "", "<init>", "()V", "easterEggMessages", "", "", "showPopup", "", "event", "Lnet/neoforged/neoforge/event/entity/player/CanContinueSleepingEvent;", "player", "Lnet/minecraft/server/level/ServerPlayer;", "text", "onPlayerInBed", "thebrokenscript"})
@SourceDebugExtension(value={"SMAP\nSleepMessageHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SleepMessageHandler.kt\ndev/wendigodrip/thebrokenscript/handlers/SleepMessageHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1755#2,3:88\n*S KotlinDebug\n*F\n+ 1 SleepMessageHandler.kt\ndev/wendigodrip/thebrokenscript/handlers/SleepMessageHandler\n*L\n71#1:88,3\n*E\n"})
public final class SleepMessageHandler {
    @NotNull
    public static final SleepMessageHandler INSTANCE = new SleepMessageHandler();
    @NotNull
    private static final Map<String, String> easterEggMessages;

    private SleepMessageHandler() {
    }

    private final void showPopup(CanContinueSleepingEvent event, ServerPlayer player, String text) {
        event.setContinueSleeping(false);
        player.hurt(player.level().damageSources().fellOutOfWorld(), 0.1f);
        PlayerExt.INSTANCE.tryShowAlert((Player)player, "LWJGL Alert", text);
    }

    @SubscribeEvent
    public final void onPlayerInBed(@NotNull CanContinueSleepingEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LivingEntity player = event.getEntity();
        Level level = event.getEntity().level();
        Intrinsics.checkNotNull((Object)level);
        MapVariables mapVars = LevelExt.INSTANCE.getVars((LevelAccessor)level);
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        PlayerVariables vars = PlayerExt.INSTANCE.getVars((Player)player);
        vars.setHomePos(((ServerPlayer)player).blockPosition());
        vars.syncTo((Player)player);
        mapVars.setHasCircuitSpawned(false);
        mapVars.syncData((LevelAccessor)level);
        LevelAccessor levelAccessor = (LevelAccessor)level;
        Vec3 vec3 = ((ServerPlayer)player).position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        Constable[] constableArray = new Class[]{NullWatchingEntity.class, NullFlyingEntity.class};
        if (EntityFinder.INSTANCE.hasEntitiesInRange(levelAccessor, vec3, 4000, (Class<? extends Entity>[])constableArray)) {
            this.showPopup(event, (ServerPlayer)player, "err.null");
        } else {
            LevelAccessor levelAccessor2 = (LevelAccessor)level;
            Vec3 vec32 = ((ServerPlayer)player).position();
            Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"position(...)");
            if (EntityFinder.INSTANCE.hasEntitiesInRange(levelAccessor2, NoTextureEntity.class, vec32, 4000)) {
                this.showPopup(event, (ServerPlayer)player, "err.texture");
            } else {
                LevelAccessor levelAccessor3 = (LevelAccessor)level;
                Vec3 vec33 = ((ServerPlayer)player).position();
                Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"position(...)");
                constableArray = new Class[]{SiluetStareEntity.class, SiluetEntity.class};
                if (EntityFinder.INSTANCE.hasEntitiesInRange(levelAccessor3, vec33, 4000, (Class<? extends Entity>[])constableArray)) {
                    this.showPopup(event, (ServerPlayer)player, "err.soul");
                } else {
                    LevelAccessor levelAccessor4 = (LevelAccessor)level;
                    Vec3 vec34 = ((ServerPlayer)player).position();
                    Intrinsics.checkNotNullExpressionValue((Object)vec34, (String)"position(...)");
                    constableArray = new Class[]{TheBrokenEndOverhaulStalkEntity.class, TheBrokenEndEntity.class};
                    if (EntityFinder.INSTANCE.hasEntitiesInRange(levelAccessor4, vec34, 4000, (Class<? extends Entity>[])constableArray)) {
                        this.showPopup(event, (ServerPlayer)player, "err.endisnear");
                    } else {
                        boolean bl;
                        block17: {
                            constableArray = new Integer[]{4, 5, 6, 7};
                            Iterable $this$any$iv = CollectionsKt.listOf((Object[])constableArray);
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    int it = ((Number)element$iv).intValue();
                                    boolean bl2 = false;
                                    if (!(level.dimensionType().moonPhase(level.dayTime()) == it)) continue;
                                    bl = true;
                                    break block17;
                                }
                                bl = false;
                            }
                        }
                        if (bl && mapVars.getMoonPhase() != 0) {
                            if (level.random.nextBoolean()) {
                                String string = ((ServerPlayer)player).getGameProfile().getId().toString();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                                String uuid = string;
                                String message = easterEggMessages.get(uuid);
                                if (message != null) {
                                    this.showPopup(event, (ServerPlayer)player, message);
                                } else {
                                    this.showPopup(event, (ServerPlayer)player, "err.themoon");
                                }
                            } else {
                                this.showPopup(event, (ServerPlayer)player, "err.themoon");
                            }
                        }
                    }
                }
            }
        }
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"d597eaf2-d68e-410b-870f-5f71e5ad7457", (Object)"err.editing"), TuplesKt.to((Object)"2a89d17b-3ce5-4d1a-ab75-bff97b3df012", (Object)"err.shattered"), TuplesKt.to((Object)"d32a4454-ee1f-4611-ae7c-dcb6f9859fea", (Object)"err.fatter"), TuplesKt.to((Object)"572e10b1-a0ef-46bd-a2f2-cdc445ac8f2e", (Object)"err.fatter"), TuplesKt.to((Object)"d4bb4431-7daf-4642-bb14-a1f8fe9ae101", (Object)"err.swag")};
        easterEggMessages = MapsKt.mapOf((Pair[])pairArray);
    }
}

