/*
 * Decompiled with CFR 0.152.
 */
package dev.wendigodrip.thebrokenscript.mixins;

import dev.wendigodrip.thebrokenscript.entity.circuit.CircuitEntity;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PauseScreen.class})
public class PauseScreenMixin {
    @Shadow
    private Button disconnectButton;

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void disableSaveAndQuitButton(CallbackInfo ci) {
        if (this.disconnectButton != null) {
            this.disconnectButton.active = !this.tbs$isCircuitNearby();
        }
    }

    @Unique
    private boolean tbs$isCircuitNearby() {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        ClientLevel world = minecraft.level;
        if (player == null || world == null) {
            return false;
        }
        List entities = world.getEntitiesOfClass(CircuitEntity.class, player.getBoundingBox().inflate(1000.0));
        return !entities.isEmpty();
    }
}

