/*
 * Decompiled with CFR 0.152.
 */
package dev.wendigodrip.thebrokenscript.world.dimension;

import dev.wendigodrip.thebrokenscript.TheBrokenScript;
import dev.wendigodrip.thebrokenscript.api.ext.BlockPosExt;
import dev.wendigodrip.thebrokenscript.api.ext.EntityExt;
import dev.wendigodrip.thebrokenscript.api.ext.LevelExt;
import dev.wendigodrip.thebrokenscript.api.ext.PlayerExt;
import dev.wendigodrip.thebrokenscript.registry.TBSBlocks;
import dev.wendigodrip.thebrokenscript.registry.TBSDimensions;
import dev.wendigodrip.thebrokenscript.vars.MapVariables;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Ldev/wendigodrip/thebrokenscript/world/dimension/ClanVoidDimension;", "", "<init>", "()V", "onPlayerChangedDimensionEvent", "", "event", "Lnet/neoforged/neoforge/event/entity/player/PlayerEvent$PlayerChangedDimensionEvent;", "thebrokenscript"})
public final class ClanVoidDimension {
    @NotNull
    public static final ClanVoidDimension INSTANCE = new ClanVoidDimension();

    private ClanVoidDimension() {
    }

    @SubscribeEvent
    public final void onPlayerChangedDimensionEvent(@NotNull PlayerEvent.PlayerChangedDimensionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Intrinsics.areEqual((Object)event.getTo(), TBSDimensions.CLAN_VOID)) {
            return;
        }
        Player entity = event.getEntity();
        Level level = entity.level();
        Intrinsics.checkNotNull((Object)level);
        MapVariables vars = LevelExt.INSTANCE.getVars((LevelAccessor)level);
        if (!vars.getHasGeneratedClanBuildDimension()) {
            vars.setHasGeneratedClanBuildDimension(true);
            vars.syncData((LevelAccessor)level);
            BlockPos blockPos = entity.blockPosition();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPosition(...)");
            level.setBlock(BlockPosExt.INSTANCE.withY(blockPos, 200), TBSBlocks.CLANBUILD_ANOMALY_GENERATOR.getDefaultState(), 3);
        }
        entity.setNoGravity(true);
        Intrinsics.checkNotNull((Object)entity);
        PlayerExt.INSTANCE.getVars(entity).setTicksUntilExit(18000L);
        TheBrokenScript.INSTANCE.queueServerWork$thebrokenscript(35, () -> ClanVoidDimension.onPlayerChangedDimensionEvent$lambda$0(entity));
        TheBrokenScript.INSTANCE.queueServerWork$thebrokenscript(40, () -> ClanVoidDimension.onPlayerChangedDimensionEvent$lambda$1(level, entity));
    }

    private static final void onPlayerChangedDimensionEvent$lambda$0(Player $entity) {
        Entity entity = (Entity)$entity;
        BlockPos blockPos = $entity.blockPosition();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPosition(...)");
        BlockPos blockPos2 = BlockPosExt.INSTANCE.withY(blockPos, 203).offset(4, 0, 4);
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"offset(...)");
        EntityExt.INSTANCE.teleport(entity, blockPos2);
    }

    private static final void onPlayerChangedDimensionEvent$lambda$1(Level $level, Player $entity) {
        if (!$level.getBlockState($entity.blockPosition().above()).isAir()) {
            Entity entity = (Entity)$entity;
            BlockPos blockPos = $entity.blockPosition().offset(2, -1, 2);
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"offset(...)");
            EntityExt.INSTANCE.teleport(entity, blockPos);
        }
        $entity.setNoGravity(false);
    }
}

