/*
 * Decompiled with CFR 0.152.
 */
package dev.wendigodrip.thebrokenscript.api.ext;

import dev.wendigodrip.thebrokenscript.TheBrokenScript;
import dev.wendigodrip.thebrokenscript.api.network.PacketSender;
import dev.wendigodrip.thebrokenscript.registry.TBSDataAttachments;
import dev.wendigodrip.thebrokenscript.registry.TBSPackets;
import dev.wendigodrip.thebrokenscript.vars.PlayerVariables;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u00020\f*\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0012\u0010\u0010\u001a\u00020\f*\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012J\n\u0010\u001a\u001a\u00020\u0007*\u00020\bJ\u001a\u0010\u001b\u001a\u00020\f*\u00020\b2\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eJ\u001a\u0010\u001b\u001a\u00020\f*\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u001eJ\n\u0010 \u001a\u00020\f*\u00020\bJ\u001a\u0010!\u001a\u00020\f*\u00020\b2\u0006\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u001fJ!\u0010$\u001a\u00020\f\"\b\b\u0000\u0010%*\u00020&*\u00020\b2\u0006\u0010'\u001a\u0002H%\u00a2\u0006\u0002\u0010(JD\u0010)\u001a\u00020\f*\u00020\b2\u0006\u0010*\u001a\u00020+2\b\b\u0002\u0010,\u001a\u00020-2\b\b\u0002\u0010.\u001a\u00020-2\b\b\u0002\u0010/\u001a\u0002002\b\b\u0002\u00101\u001a\u0002022\b\b\u0002\u00103\u001a\u000204JJ\u0010)\u001a\u00020\f*\u00020\b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+052\b\b\u0002\u0010,\u001a\u00020-2\b\b\u0002\u0010.\u001a\u00020-2\b\b\u0002\u0010/\u001a\u0002002\b\b\u0002\u00101\u001a\u0002022\b\b\u0002\u00103\u001a\u000204JD\u00106\u001a\u00020\f*\u0002072\u0006\u0010*\u001a\u00020+2\b\b\u0002\u0010,\u001a\u00020-2\b\b\u0002\u0010.\u001a\u00020-2\b\b\u0002\u0010/\u001a\u0002002\b\b\u0002\u00101\u001a\u0002022\b\b\u0002\u00103\u001a\u000204JJ\u00106\u001a\u00020\f*\u0002072\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+052\b\b\u0002\u0010,\u001a\u00020-2\b\b\u0002\u0010.\u001a\u00020-2\b\b\u0002\u0010/\u001a\u0002002\b\b\u0002\u00101\u001a\u0002022\b\b\u0002\u00103\u001a\u000204J\u0012\u0010>\u001a\u00020\f*\u0002072\u0006\u0010\u0013\u001a\u00020\u001fJ\u0012\u0010?\u001a\u00020\f*\u00020\b2\u0006\u0010@\u001a\u00020AJ\u0012\u0010B\u001a\u00020\f*\u0002072\u0006\u0010@\u001a\u00020AJ\n\u0010C\u001a\u00020\f*\u000207R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R,\u0010\u0015\u001a\u0004\u0018\u00010\u0014*\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00148F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R(\u00109\u001a\u000208*\u00020\b2\u0006\u0010\u0013\u001a\u0002088F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R(\u0010D\u001a\u000204*\u0002072\u0006\u0010\u0013\u001a\u0002048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bE\u0010F\"\u0004\bG\u0010H\u00a8\u0006I"}, d2={"Ldev/wendigodrip/thebrokenscript/api/ext/PlayerExt;", "", "<init>", "()V", "MARGIN", "", "isLookingAt", "", "Lnet/minecraft/world/entity/player/Player;", "entity", "Lnet/minecraft/world/entity/Entity;", "sendTo", "", "dest", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/level/Level;", "awardAdvancement", "location", "Lnet/minecraft/resources/ResourceLocation;", "value", "Lnet/minecraft/world/level/GameType;", "gameMode", "getGameMode", "(Lnet/minecraft/world/entity/player/Player;)Lnet/minecraft/world/level/GameType;", "setGameMode", "(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/level/GameType;)V", "isMultiplayer", "trySendOverlay", "texture", "duration", "", "", "tryClearOverlays", "tryShowAlert", "title", "message", "trySendCustomPacket", "P", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload;", "packet", "(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload;)V", "trySendSound", "sound", "Lnet/minecraft/sounds/SoundEvent;", "volume", "", "pitch", "source", "Lnet/minecraft/sounds/SoundSource;", "pos", "Lnet/minecraft/world/phys/Vec3;", "seed", "", "Lnet/minecraft/core/Holder;", "sendSound", "Lnet/minecraft/server/level/ServerPlayer;", "Ldev/wendigodrip/thebrokenscript/vars/PlayerVariables;", "vars", "getVars", "(Lnet/minecraft/world/entity/player/Player;)Ldev/wendigodrip/thebrokenscript/vars/PlayerVariables;", "setVars", "(Lnet/minecraft/world/entity/player/Player;Ldev/wendigodrip/thebrokenscript/vars/PlayerVariables;)V", "updateAltConsoleCommand", "setActionBar", "text", "Lnet/minecraft/network/chat/Component;", "kick", "stopAllSounds", "moonGlitchDuration", "getMoonGlitchDuration", "(Lnet/minecraft/server/level/ServerPlayer;)J", "setMoonGlitchDuration", "(Lnet/minecraft/server/level/ServerPlayer;J)V", "thebrokenscript"})
@SourceDebugExtension(value={"SMAP\nPlayerExt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerExt.kt\ndev/wendigodrip/thebrokenscript/api/ext/PlayerExt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,170:1\n1863#2,2:171\n*S KotlinDebug\n*F\n+ 1 PlayerExt.kt\ndev/wendigodrip/thebrokenscript/api/ext/PlayerExt\n*L\n64#1:171,2\n*E\n"})
public final class PlayerExt {
    @NotNull
    public static final PlayerExt INSTANCE = new PlayerExt();
    private static final double MARGIN = 0.025;

    private PlayerExt() {
    }

    public final boolean isLookingAt(@NotNull Player $this$isLookingAt, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)$this$isLookingAt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Vec3 normalizedView = $this$isLookingAt.getViewVector(1.0f).normalize();
        Vec3 center = new Vec3(entity.getX() - $this$isLookingAt.getX(), entity.getEyeY() - $this$isLookingAt.getEyeY(), entity.getZ() - $this$isLookingAt.getZ());
        double distance = center.length();
        center = center.normalize();
        double viewCenterDiff = normalizedView.dot(center);
        return viewCenterDiff > 1.0 - 0.025 / distance ? $this$isLookingAt.hasLineOfSight(entity) : false;
    }

    public final void sendTo(@NotNull Player $this$sendTo, @NotNull ResourceKey<Level> dest) {
        Intrinsics.checkNotNullParameter((Object)$this$sendTo, (String)"<this>");
        Intrinsics.checkNotNullParameter(dest, (String)"dest");
        if (!($this$sendTo instanceof ServerPlayer)) {
            return;
        }
        if (Intrinsics.areEqual((Object)$this$sendTo.level().dimension(), dest)) {
            return;
        }
        ServerLevel nextLevel = ((ServerPlayer)$this$sendTo).server.getLevel(dest);
        if (nextLevel != null) {
            TheBrokenScript.INSTANCE.queueServerWork$thebrokenscript(1, () -> PlayerExt.sendTo$lambda$0($this$sendTo, nextLevel));
        }
    }

    public final void awardAdvancement(@NotNull Player $this$awardAdvancement, @NotNull ResourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)$this$awardAdvancement, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        if (!($this$awardAdvancement instanceof ServerPlayer)) {
            return;
        }
        AdvancementHolder advancementHolder = ((ServerPlayer)$this$awardAdvancement).server.getAdvancements().get(location);
        if (advancementHolder == null) {
            return;
        }
        AdvancementHolder advancement = advancementHolder;
        AdvancementProgress progress = ((ServerPlayer)$this$awardAdvancement).getAdvancements().getOrStartProgress(advancement);
        if (!progress.isDone()) {
            Iterable iterable = progress.getRemainingCriteria();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getRemainingCriteria(...)");
            Iterable $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                ((ServerPlayer)$this$awardAdvancement).getAdvancements().award(advancement, it);
            }
        }
    }

    @Nullable
    public final GameType getGameMode(@NotNull Player $this$gameMode) {
        Intrinsics.checkNotNullParameter((Object)$this$gameMode, (String)"<this>");
        if ($this$gameMode instanceof ServerPlayer) {
            return ((ServerPlayer)$this$gameMode).gameMode.getGameModeForPlayer();
        }
        ClientPacketListener clientPacketListener = Minecraft.getInstance().getConnection();
        Intrinsics.checkNotNull((Object)clientPacketListener);
        PlayerInfo playerInfo = clientPacketListener.getPlayerInfo($this$gameMode.getGameProfile().getId());
        return playerInfo != null ? playerInfo.getGameMode() : null;
    }

    public final void setGameMode(@NotNull Player $this$gameMode, @Nullable GameType value) {
        Intrinsics.checkNotNullParameter((Object)$this$gameMode, (String)"<this>");
        if ($this$gameMode instanceof ServerPlayer && value != null) {
            ((ServerPlayer)$this$gameMode).setGameMode(value);
        }
    }

    public final boolean isMultiplayer(@NotNull Player $this$isMultiplayer) {
        Intrinsics.checkNotNullParameter((Object)$this$isMultiplayer, (String)"<this>");
        MinecraftServer minecraftServer = $this$isMultiplayer.getServer();
        return minecraftServer != null ? minecraftServer.isPublished() : false;
    }

    public final void trySendOverlay(@NotNull Player $this$trySendOverlay, @NotNull ResourceLocation texture, int duration) {
        Intrinsics.checkNotNullParameter((Object)$this$trySendOverlay, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        if ($this$trySendOverlay instanceof ServerPlayer) {
            PacketSender.INSTANCE.sendToPlayer((ServerPlayer)$this$trySendOverlay, TBSPackets.SHOW_OVERLAY.of(texture, duration), new CustomPacketPayload[0]);
        }
    }

    public final void trySendOverlay(@NotNull Player $this$trySendOverlay, @NotNull String texture, int duration) {
        Intrinsics.checkNotNullParameter((Object)$this$trySendOverlay, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        if ($this$trySendOverlay instanceof ServerPlayer) {
            PacketSender.INSTANCE.sendToPlayer((ServerPlayer)$this$trySendOverlay, TBSPackets.SHOW_OVERLAY.of$thebrokenscript(texture, duration), new CustomPacketPayload[0]);
        }
    }

    public final void tryClearOverlays(@NotNull Player $this$tryClearOverlays) {
        Intrinsics.checkNotNullParameter((Object)$this$tryClearOverlays, (String)"<this>");
        if ($this$tryClearOverlays instanceof ServerPlayer) {
            PacketSender.INSTANCE.sendToPlayer((ServerPlayer)$this$tryClearOverlays, (CustomPacketPayload)TBSPackets.CLEAR_OVERLAYS.create(), new CustomPacketPayload[0]);
        }
    }

    public final void tryShowAlert(@NotNull Player $this$tryShowAlert, @NotNull String title, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)$this$tryShowAlert, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.trySendCustomPacket($this$tryShowAlert, (CustomPacketPayload)TBSPackets.OPEN_ALERT_POPUP.of(title, message));
    }

    public final <P extends CustomPacketPayload> void trySendCustomPacket(@NotNull Player $this$trySendCustomPacket, @NotNull P packet) {
        Intrinsics.checkNotNullParameter((Object)$this$trySendCustomPacket, (String)"<this>");
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        if ($this$trySendCustomPacket instanceof ServerPlayer) {
            PacketSender.INSTANCE.sendToPlayer((ServerPlayer)$this$trySendCustomPacket, packet, new CustomPacketPayload[0]);
        }
    }

    public final void trySendSound(@NotNull Player $this$trySendSound, @NotNull SoundEvent sound, float volume, float pitch, @NotNull SoundSource source, @NotNull Vec3 pos, long seed) {
        Intrinsics.checkNotNullParameter((Object)$this$trySendSound, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if ($this$trySendSound instanceof ServerPlayer) {
            this.sendSound((ServerPlayer)$this$trySendSound, sound, volume, pitch, source, pos, seed);
        }
    }

    public static /* synthetic */ void trySendSound$default(PlayerExt playerExt, Player player, SoundEvent soundEvent, float f, float f2, SoundSource soundSource, Vec3 vec3, long l, int n, Object object) {
        if ((n & 2) != 0) {
            f = 1.0f;
        }
        if ((n & 4) != 0) {
            f2 = 1.0f;
        }
        if ((n & 8) != 0) {
            soundSource = SoundSource.MASTER;
        }
        if ((n & 0x10) != 0) {
            vec3 = player.position();
        }
        if ((n & 0x20) != 0) {
            l = player.level().random.nextLong();
        }
        playerExt.trySendSound(player, soundEvent, f, f2, soundSource, vec3, l);
    }

    public final void trySendSound(@NotNull Player $this$trySendSound, @NotNull Holder<SoundEvent> sound, float volume, float pitch, @NotNull SoundSource source, @NotNull Vec3 pos, long seed) {
        Intrinsics.checkNotNullParameter((Object)$this$trySendSound, (String)"<this>");
        Intrinsics.checkNotNullParameter(sound, (String)"sound");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if ($this$trySendSound instanceof ServerPlayer) {
            this.sendSound((ServerPlayer)$this$trySendSound, sound, volume, pitch, source, pos, seed);
        }
    }

    public static /* synthetic */ void trySendSound$default(PlayerExt playerExt, Player player, Holder holder, float f, float f2, SoundSource soundSource, Vec3 vec3, long l, int n, Object object) {
        if ((n & 2) != 0) {
            f = 1.0f;
        }
        if ((n & 4) != 0) {
            f2 = 1.0f;
        }
        if ((n & 8) != 0) {
            soundSource = SoundSource.MASTER;
        }
        if ((n & 0x10) != 0) {
            vec3 = player.position();
        }
        if ((n & 0x20) != 0) {
            l = player.level().random.nextLong();
        }
        playerExt.trySendSound(player, (Holder<SoundEvent>)holder, f, f2, soundSource, vec3, l);
    }

    public final void sendSound(@NotNull ServerPlayer $this$sendSound, @NotNull SoundEvent sound, float volume, float pitch, @NotNull SoundSource source, @NotNull Vec3 pos, long seed) {
        Intrinsics.checkNotNullParameter((Object)$this$sendSound, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Holder holder = Holder.direct((Object)sound);
        Intrinsics.checkNotNullExpressionValue((Object)holder, (String)"direct(...)");
        this.sendSound($this$sendSound, (Holder<SoundEvent>)holder, volume, pitch, source, pos, seed);
    }

    public static /* synthetic */ void sendSound$default(PlayerExt playerExt, ServerPlayer serverPlayer, SoundEvent soundEvent, float f, float f2, SoundSource soundSource, Vec3 vec3, long l, int n, Object object) {
        if ((n & 2) != 0) {
            f = 1.0f;
        }
        if ((n & 4) != 0) {
            f2 = 1.0f;
        }
        if ((n & 8) != 0) {
            soundSource = SoundSource.MASTER;
        }
        if ((n & 0x10) != 0) {
            vec3 = serverPlayer.position();
        }
        if ((n & 0x20) != 0) {
            l = serverPlayer.level().random.nextLong();
        }
        playerExt.sendSound(serverPlayer, soundEvent, f, f2, soundSource, vec3, l);
    }

    public final void sendSound(@NotNull ServerPlayer $this$sendSound, @NotNull Holder<SoundEvent> sound, float volume, float pitch, @NotNull SoundSource source, @NotNull Vec3 pos, long seed) {
        Intrinsics.checkNotNullParameter((Object)$this$sendSound, (String)"<this>");
        Intrinsics.checkNotNullParameter(sound, (String)"sound");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        $this$sendSound.connection.send((Packet)new ClientboundSoundPacket(sound, source, pos.x, pos.y, pos.z, volume, pitch, seed));
    }

    public static /* synthetic */ void sendSound$default(PlayerExt playerExt, ServerPlayer serverPlayer, Holder holder, float f, float f2, SoundSource soundSource, Vec3 vec3, long l, int n, Object object) {
        if ((n & 2) != 0) {
            f = 1.0f;
        }
        if ((n & 4) != 0) {
            f2 = 1.0f;
        }
        if ((n & 8) != 0) {
            soundSource = SoundSource.MASTER;
        }
        if ((n & 0x10) != 0) {
            vec3 = serverPlayer.position();
        }
        if ((n & 0x20) != 0) {
            l = serverPlayer.level().random.nextLong();
        }
        playerExt.sendSound(serverPlayer, (Holder<SoundEvent>)holder, f, f2, soundSource, vec3, l);
    }

    @NotNull
    public final PlayerVariables getVars(@NotNull Player $this$vars) {
        Intrinsics.checkNotNullParameter((Object)$this$vars, (String)"<this>");
        Object object = $this$vars.getData(TBSDataAttachments.PLAYER_VARIABLES);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
        return (PlayerVariables)object;
    }

    public final void setVars(@NotNull Player $this$vars, @NotNull PlayerVariables value) {
        Intrinsics.checkNotNullParameter((Object)$this$vars, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        $this$vars.setData(TBSDataAttachments.PLAYER_VARIABLES, (Object)value);
    }

    public final void updateAltConsoleCommand(@NotNull ServerPlayer $this$updateAltConsoleCommand, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$updateAltConsoleCommand, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        PacketSender.INSTANCE.sendToPlayer($this$updateAltConsoleCommand, (CustomPacketPayload)TBSPackets.UPDATE_ALT_CONSOLE_COMMAND.of(value), new CustomPacketPayload[0]);
    }

    public final void setActionBar(@NotNull Player $this$setActionBar, @NotNull Component text) {
        Intrinsics.checkNotNullParameter((Object)$this$setActionBar, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        $this$setActionBar.displayClientMessage(text, true);
    }

    public final void kick(@NotNull ServerPlayer $this$kick, @NotNull Component text) {
        Intrinsics.checkNotNullParameter((Object)$this$kick, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        $this$kick.connection.disconnect(text);
    }

    public final void stopAllSounds(@NotNull ServerPlayer $this$stopAllSounds) {
        Intrinsics.checkNotNullParameter((Object)$this$stopAllSounds, (String)"<this>");
        $this$stopAllSounds.connection.send((Packet)new ClientboundStopSoundPacket(null, null));
    }

    public final long getMoonGlitchDuration(@NotNull ServerPlayer $this$moonGlitchDuration) {
        Intrinsics.checkNotNullParameter((Object)$this$moonGlitchDuration, (String)"<this>");
        return this.getVars((Player)$this$moonGlitchDuration).getMoonGlitchDuration();
    }

    public final void setMoonGlitchDuration(@NotNull ServerPlayer $this$moonGlitchDuration, long value) {
        PlayerVariables playerVariables;
        Intrinsics.checkNotNullParameter((Object)$this$moonGlitchDuration, (String)"<this>");
        PlayerVariables it = playerVariables = this.getVars((Player)$this$moonGlitchDuration);
        boolean bl = false;
        it.setMoonGlitchDuration(value);
        it.syncTo((Player)$this$moonGlitchDuration);
    }

    private static final void sendTo$lambda$0(Player $this_sendTo, ServerLevel $nextLevel) {
        ((ServerPlayer)$this_sendTo).changeDimension(new DimensionTransition($nextLevel, $this_sendTo.position(), ((ServerPlayer)$this_sendTo).getDeltaMovement(), ((ServerPlayer)$this_sendTo).getYRot(), ((ServerPlayer)$this_sendTo).getXRot(), DimensionTransition.PLAY_PORTAL_SOUND));
    }
}

