/*
 * Decompiled with CFR 0.152.
 */
package dev.wendigodrip.thebrokenscript.api.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t\u00a8\u0006\f"}, d2={"Ldev/wendigodrip/thebrokenscript/api/util/ChunkUtil;", "", "<init>", "()V", "moveChunkUp", "", "level", "Lnet/minecraft/server/level/ServerLevel;", "chunkX", "", "chunkZ", "offsetY", "thebrokenscript"})
public final class ChunkUtil {
    @NotNull
    public static final ChunkUtil INSTANCE = new ChunkUtil();

    private ChunkUtil() {
    }

    public final void moveChunkUp(@NotNull ServerLevel level, int chunkX, int chunkZ, int offsetY) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int n = level.getMaxBuildHeight();
                for (int y = level.getMinBuildHeight(); y < n; ++y) {
                    BlockPos oldPos = new BlockPos(chunkX * 16 + x, y, chunkZ * 16 + z);
                    BlockPos newPos = oldPos.above(offsetY);
                    BlockState oldState = level.getBlockState(oldPos);
                    BlockEntity oldTile = level.getBlockEntity(oldPos);
                    level.setBlock(newPos, oldState, 3);
                    BlockEntity newTile = level.getBlockEntity(newPos);
                    if (oldTile != null && newTile != null) {
                        newTile.loadWithComponents(oldTile.saveWithFullMetadata((HolderLookup.Provider)level.registryAccess()), (HolderLookup.Provider)level.registryAccess());
                        newTile.setChanged();
                    }
                    level.setBlock(oldPos, Blocks.AIR.defaultBlockState(), 3);
                }
            }
        }
    }
}

