/*
 * Decompiled with CFR 0.152.
 */
package dev.wendigodrip.thebrokenscript.entity.circuit;

import dev.wendigodrip.thebrokenscript.TheBrokenScript;
import dev.wendigodrip.thebrokenscript.api.entity.FinalizedSpawn;
import dev.wendigodrip.thebrokenscript.api.entity.base.BaseCircuitEntity;
import dev.wendigodrip.thebrokenscript.api.entity.base.BaseMonster;
import dev.wendigodrip.thebrokenscript.api.ext.EntityExt;
import dev.wendigodrip.thebrokenscript.api.ext.EntityFinder;
import dev.wendigodrip.thebrokenscript.api.ext.EntityTypeExt;
import dev.wendigodrip.thebrokenscript.api.ext.LevelExt;
import dev.wendigodrip.thebrokenscript.api.ext.PlayerExt;
import dev.wendigodrip.thebrokenscript.api.ext.PlayerListExt;
import dev.wendigodrip.thebrokenscript.api.ext.PosExt;
import dev.wendigodrip.thebrokenscript.api.ext.TagExt;
import dev.wendigodrip.thebrokenscript.api.util.BlockBreakHelper;
import dev.wendigodrip.thebrokenscript.api.world.TimeOfDay;
import dev.wendigodrip.thebrokenscript.entity.circuit.CircuitUtil;
import dev.wendigodrip.thebrokenscript.registry.TBSEntities;
import dev.wendigodrip.thebrokenscript.registry.TBSSounds;
import dev.wendigodrip.thebrokenscript.vars.MapVariables;
import dev.wendigodrip.thebrokenscript.vars.PlayerVariables;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J4\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0005\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006 "}, d2={"Ldev/wendigodrip/thebrokenscript/entity/circuit/CircuitEntity;", "Ldev/wendigodrip/thebrokenscript/api/entity/base/BaseCircuitEntity;", "Ldev/wendigodrip/thebrokenscript/api/entity/FinalizedSpawn;", "type", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "baseTick", "", "awardKillScore", "entity", "Lnet/minecraft/world/entity/Entity;", "score", "", "damageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "onFinalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnType", "Lnet/minecraft/world/entity/MobSpawnType;", "spawnData", "event", "Lnet/neoforged/neoforge/event/entity/living/FinalizeSpawnEvent;", "movementPredicate", "Lsoftware/bernie/geckolib/animation/PlayState;", "Lsoftware/bernie/geckolib/animation/AnimationState;", "die", "thebrokenscript"})
public final class CircuitEntity
extends BaseCircuitEntity
implements FinalizedSpawn {
    public CircuitEntity(@NotNull EntityType<CircuitEntity> type, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(type, level);
    }

    public void baseTick() {
        super.baseTick();
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        double breakY = this.random.nextInt(1, 5);
        List<ServerPlayer> playersInRange = EntityFinder.INSTANCE.findPlayersInRange((ServerLevel)level, this.getPos(), (Number)1000);
        List players = new ArrayList();
        for (ServerPlayer player : playersInRange) {
            if (player.hasLineOfSight((Entity)this)) {
                players.add(player);
                continue;
            }
            CircuitUtil.INSTANCE.resetNoWayOutFrame((Player)player);
        }
        ServerPlayer serverPlayer = (ServerPlayer)EntityExt.INSTANCE.closest(players, this.getPos());
        if (serverPlayer == null) {
            this.refreshDimensions();
            return;
        }
        ServerPlayer closest = serverPlayer;
        this.setTarget((LivingEntity)closest);
        LevelAccessor levelAccessor = (LevelAccessor)level;
        BlockPos blockPos = BlockPos.containing((double)(this.getX() + 1.0), (double)breakY, (double)this.getZ());
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"containing(...)");
        BlockBreakHelper.INSTANCE.tryBreakCircuit(levelAccessor, blockPos);
        LevelAccessor levelAccessor2 = (LevelAccessor)level;
        BlockPos blockPos2 = BlockPos.containing((double)(this.getX() - 1.0), (double)breakY, (double)this.getZ());
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"containing(...)");
        BlockBreakHelper.INSTANCE.tryBreakCircuit(levelAccessor2, blockPos2);
        LevelAccessor levelAccessor3 = (LevelAccessor)level;
        BlockPos blockPos3 = BlockPos.containing((double)this.getX(), (double)breakY, (double)(this.getZ() + 1.0));
        Intrinsics.checkNotNullExpressionValue((Object)blockPos3, (String)"containing(...)");
        BlockBreakHelper.INSTANCE.tryBreakCircuit(levelAccessor3, blockPos3);
        LevelAccessor levelAccessor4 = (LevelAccessor)level;
        BlockPos blockPos4 = BlockPos.containing((double)this.getX(), (double)breakY, (double)(this.getZ() - 1.0));
        Intrinsics.checkNotNullExpressionValue((Object)blockPos4, (String)"containing(...)");
        BlockBreakHelper.INSTANCE.tryBreakCircuit(levelAccessor4, blockPos4);
        CompoundTag compoundTag = this.getPersistentData();
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"getPersistentData(...)");
        if (TagExt.INSTANCE.incInt(compoundTag, "waitTime") > 45) {
            this.getPersistentData().putInt("waitTime", 0);
            CircuitUtil.INSTANCE.incNoWayOutFrame(players);
            PlayerListExt.sendSound$default(PlayerListExt.INSTANCE, players, (LevelAccessor)level, (Holder)TBSSounds.NULL_JUMPSCARE_LOUD, 555.0f, 0.5f, null, 0L, 48, null);
            PlayerListExt.INSTANCE.trySendOverlay(players, "textures/screens/screenshot_2025-01-01_145155.png", 2);
            if ((double)this.random.nextFloat() < 0.7) {
                PlayerListExt.INSTANCE.lookAt(players, EntityAnchorArgument.Anchor.EYES, PosExt.INSTANCE.above(this.getPos(), 5));
            }
            if ((double)this.random.nextFloat() < 0.7) {
                TimeOfDay.MIDNIGHT.setFake();
                PlayerListExt.INSTANCE.trySendOverlay(players, "textures/screens/blick.png", 10);
            }
            if ((double)this.random.nextFloat() < 0.7) {
                TimeOfDay.DAY.setFake();
                PlayerListExt.INSTANCE.trySendOverlay(players, "textures/screens/frame2.png", 10);
            }
            if ((double)this.random.nextFloat() < 0.7) {
                TimeOfDay.DAY.setFake();
            }
        }
        BaseMonster.enableWaterWalking$default(this, null, 1, null);
        EntityExt.INSTANCE.discardNearest(Boat.class, this.getPos(), level, 40);
        if ((double)this.random.nextFloat() < 0.01) {
            CircuitUtil.INSTANCE.incNoWayOutFrame(players);
        }
        for (ServerPlayer player : players) {
            PlayerVariables vars = PlayerExt.INSTANCE.getVars((Player)player);
            if (vars.getNoWayOutFrame() <= 6) continue;
            vars.setNoWayOutFrame(0);
            vars.syncTo((Player)player);
        }
        this.refreshDimensions();
    }

    public void awardKillScore(@NotNull Entity entity, int score, @NotNull DamageSource damageSource) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        super.awardKillScore(entity, score, damageSource);
        if (!(this.getLevel() instanceof ServerLevel)) {
            return;
        }
        this.discard();
        if (entity instanceof ServerPlayer) {
            PlayerExt.INSTANCE.stopAllSounds((ServerPlayer)entity);
            PlayerExt.sendSound$default(PlayerExt.INSTANCE, (ServerPlayer)entity, (Holder)TBSSounds.NULL_JUMPSCARE_LOUD, 555.0f, 0.0f, null, null, 0L, 60, null);
            CircuitUtil.INSTANCE.resetNoWayOutFrame((Player)entity);
            TheBrokenScript.INSTANCE.queueServerWork$thebrokenscript(20, () -> CircuitEntity.awardKillScore$lambda$0(this, entity));
        }
    }

    @Override
    @Nullable
    public SpawnGroupData onFinalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnData, @NotNull FinalizeSpawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnType, (String)"spawnType");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        for (ServerPlayer player : EntityFinder.INSTANCE.findPlayersInRange(level, this.getPos(), (Number)500)) {
            if (!player.hasLineOfSight((Entity)this)) continue;
            PlayerExt.sendSound$default(PlayerExt.INSTANCE, player, (Holder)TBSSounds.CIRCUIT_JUMPSCARE, 555.0f, 0.0f, null, null, 0L, 60, null);
            PlayerExt.sendSound$default(PlayerExt.INSTANCE, player, (Holder)TBSSounds.NULL_JUMPSCARE_LOUD, 555.0f, 0.0f, null, null, 0L, 60, null);
            PlayerExt.sendSound$default(PlayerExt.INSTANCE, player, (Holder)TBSSounds.NULL_CHASE, 555.0f, 0.0f, null, null, 0L, 60, null);
        }
        TheBrokenScript.INSTANCE.queueServerWork$thebrokenscript(400, () -> CircuitEntity.onFinalizeSpawn$lambda$1(this, level));
        return null;
    }

    @Override
    @Nullable
    public PlayState movementPredicate(@NotNull AnimationState<?> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        if (Intrinsics.areEqual((Object)this.getAnimProcedure(), (Object)"empty")) {
            if (event.isMoving() || !(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("chase2"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.STOP;
    }

    public void die(@NotNull DamageSource damageSource) {
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        super.die(damageSource);
        Object object = TBSEntities.getCIRCUIT_STALK().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        EntityExt.INSTANCE.applyRandomRotation(EntityTypeExt.INSTANCE.trySummon((EntityType)object, (LevelAccessor)this.getLevel(), this.getPos()));
        Object object2 = TBSEntities.getCIRCUIT_STALK().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        EntityExt.INSTANCE.applyRandomRotation(EntityTypeExt.INSTANCE.trySummon((EntityType)object2, (LevelAccessor)this.getLevel(), this.getPos()));
        Object object3 = TBSEntities.getCIRCUIT_STALK().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        EntityExt.INSTANCE.applyRandomRotation(EntityTypeExt.INSTANCE.trySummon((EntityType)object3, (LevelAccessor)this.getLevel(), this.getPos()));
    }

    @Override
    public void callFinalizeSpawn(@NotNull FinalizeSpawnEvent event) {
        FinalizedSpawn.DefaultImpls.callFinalizeSpawn(this, event);
    }

    private static final void awardKillScore$lambda$0(CircuitEntity this$0, Entity $entity) {
        if ((double)this$0.random.nextFloat() >= 0.1) {
            ServerPlayer serverPlayer = (ServerPlayer)$entity;
            MutableComponent mutableComponent = Component.literal((String)(this$0.random.nextBoolean() ? "No more running." : "No more hiding."));
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
            PlayerExt.INSTANCE.kick(serverPlayer, (Component)mutableComponent);
        }
    }

    private static final void onFinalizeSpawn$lambda$1(CircuitEntity this$0, ServerLevelAccessor $level) {
        this$0.discard();
        MapVariables vars = LevelExt.INSTANCE.getVars((LevelAccessor)$level);
        vars.setHasCircuitSpawned(false);
        vars.syncData((LevelAccessor)$level);
        CircuitUtil.INSTANCE.resetNoWayOutFrame(EntityFinder.INSTANCE.findPlayersInRange($level, this$0.getPos(), (Number)500));
    }
}

