/*
 * Decompiled with CFR 0.152.
 */
package dev.wendigodrip.thebrokenscript.mixins;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.wendigodrip.thebrokenscript.api.TBSMenuBackgrounds;
import dev.wendigodrip.thebrokenscript.config.MenuMode;
import dev.wendigodrip.thebrokenscript.config.TBSConfigs;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TitleScreen.class})
public class TitleScreenMixin
extends Screen {
    @Unique
    private static final ResourceLocation MINECRAFT_LOGO = ResourceLocation.parse((String)"textures/gui/title/minecraft.png");
    @Unique
    private static final Component CREDIT_TEXT = Component.literal((String)"Some parts of this mod are inspired by");
    @Unique
    private static final Component CREDIT_TEXT_2 = Component.literal((String)"the incredible Mark101/TBOTV ARG. Go watch it!");
    @Unique
    private static final Component CREDIT_TEXT_NOTE = Component.literal((String)"Do note that the content of this mod is NOT canon to the original ARG.");
    @Unique
    private static final String YOUTUBE_LINK = "https://www.youtube.com/@unintelligible-synapse";

    protected TitleScreenMixin(Component title) {
        super(title);
    }

    @WrapOperation(method={"init"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/Button$Builder;build()Lnet/minecraft/client/gui/components/Button;")})
    private Button disableButtons(Button.Builder instance, Operation<Button> original) {
        Button button = (Button)original.call(new Object[]{instance});
        if (!button.getMessage().getString().equals(I18n.get((String)"menu.quit", (Object[])new Object[0]))) {
            return button;
        }
        button.active = false;
        return button;
    }

    @Inject(method={"<init>(ZLnet/minecraft/client/gui/components/LogoRenderer;)V"}, at={@At(value="TAIL")})
    private void refreshMenuBackground(CallbackInfo ci) {
        if (TBSConfigs.CLIENT.getMainMenuMode() != MenuMode.FANART) {
            return;
        }
        TBSMenuBackgrounds.refreshMenuBackground();
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void repositionButtons(CallbackInfo ci) {
        if (TBSConfigs.CLIENT.getMainMenuMode() != MenuMode.FANART) {
            return;
        }
        TitleScreen screen = (TitleScreen)this;
        for (Renderable renderable : screen.renderables) {
            if (!(renderable instanceof Button)) continue;
            Button button = (Button)renderable;
            if (renderable instanceof PlainTextButton) continue;
            button.setX(button.getX() - this.width / 2 + 138);
        }
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void addCredits(CallbackInfo ci) {
        int textHeight = 10;
        int textSpacing = 2;
        int creditWidth = this.font.width((FormattedText)CREDIT_TEXT);
        int credit2Width = this.font.width((FormattedText)CREDIT_TEXT_2);
        int noteWidth = this.font.width((FormattedText)CREDIT_TEXT_NOTE);
        int creditPosX = this.width - creditWidth - 2;
        int creditPosY = this.height - 40 - 8;
        int credit2PosX = this.width - credit2Width - 2;
        int credit2PosY = this.height - 30 - 6;
        int notePosX = this.width - noteWidth - 2;
        int notePosY = this.height - 20 - 4;
        this.addRenderableWidget((GuiEventListener)new PlainTextButton(creditPosX, creditPosY, creditWidth, 10, CREDIT_TEXT, btn -> Util.getPlatform().openUri(YOUTUBE_LINK), this.font));
        this.addRenderableWidget((GuiEventListener)new PlainTextButton(credit2PosX, credit2PosY, credit2Width, 10, CREDIT_TEXT_2, btn -> Util.getPlatform().openUri(YOUTUBE_LINK), this.font));
        this.addRenderableWidget((GuiEventListener)new StringWidget(notePosX, notePosY, noteWidth, 10, CREDIT_TEXT_NOTE, this.font));
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void repositionMinecraftLogo(GuiGraphics graphics, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (TBSConfigs.CLIENT.getMainMenuMode() != MenuMode.FANART) {
            return;
        }
        int logoX = 100;
        int logoY = 10;
        int width = 256;
        int height = 44;
        graphics.blit(MINECRAFT_LOGO, logoX, logoY, 50.0f, 10.0f, width, height, width, height);
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/LogoRenderer;renderLogo(Lnet/minecraft/client/gui/GuiGraphics;IF)V"), index=1)
    private int modifyTitlePosition(int screenWidth) {
        if (TBSConfigs.CLIENT.getMainMenuMode() != MenuMode.FANART) {
            return screenWidth;
        }
        return 290;
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/SplashRenderer;render(Lnet/minecraft/client/gui/GuiGraphics;ILnet/minecraft/client/gui/Font;I)V"), index=1)
    private int modifySplashPosition(int screenWidth) {
        if (TBSConfigs.CLIENT.getMainMenuMode() != MenuMode.FANART) {
            return screenWidth;
        }
        return 290;
    }

    @Inject(method={"renderPanorama"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelPanorama(GuiGraphics guiGraphics, float partialTick, CallbackInfo ci) {
        if (TBSConfigs.CLIENT.getMainMenuMode() != MenuMode.FANART) {
            return;
        }
        ci.cancel();
    }

    @Inject(method={"renderBackground"}, at={@At(value="HEAD")})
    private void renderCustomBackground(GuiGraphics cx, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        if (TBSConfigs.CLIENT.getMainMenuMode() != MenuMode.FANART) {
            return;
        }
        cx.blit(TBSMenuBackgrounds.getMenuBackground(), 0, 0, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
    }
}

